/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.translator.kernel;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.mozilla.translator.gui.SetupDialog;
import org.mozilla.translator.kernel.DefaultSettings;
import org.mozilla.translator.kernel.Log;

public class Settings {
    private static Properties prop;

    public static void init() {
        DefaultSettings def = new DefaultSettings();
        prop = new Properties(def.getDefaults());
        try {
            FileInputStream fis = new FileInputStream("MozillaTranslator.properties");
            prop.load(fis);
            fis.close();
        }
        catch (IOException iOException) {
            SetupDialog setup = new SetupDialog(null, true);
            setup.visDialog();
            try {
                FileOutputStream fos = new FileOutputStream("MozillaTranslator.properties");
                prop.store(fos, "Settings for MozillaTranslator. DO NOT EDIT");
                fos.close();
            }
            catch (Exception exception) {
                Log.write("Error saving preferences");
            }
        }
    }

    public static void setString(String key, String value) {
        prop.setProperty(key, value);
    }

    public static String getString(String key) {
        return prop.getProperty(key);
    }
}

