/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.translator.io;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.mozilla.translator.io.MozWriter;
import org.mozilla.translator.kernel.Log;

public class DTDWriter
implements MozWriter {
    private FileOutputStream fos;
    private OutputStreamWriter osw;
    private BufferedWriter bw;

    public DTDWriter(String fileName) {
        try {
            this.fos = new FileOutputStream(fileName);
            this.osw = new OutputStreamWriter((OutputStream)this.fos, "UTF-8");
            this.bw = new BufferedWriter(this.osw);
            String line = "<!-- Translated with MozillaTranslator v2-->";
            this.bw.write(line, 0, line.length());
            this.bw.newLine();
        }
        catch (Exception e) {
            Log.write("Error opening DTD file");
            Log.write("Exception: " + e);
        }
    }

    public void open() {
    }

    public void next(String key, String value) {
        String line = value.indexOf("\"") == -1 ? "<!ENTITY " + key + " \"" + value + "\">" : "<!ENTITY " + key + " '" + value + "'>";
        try {
            this.bw.write(line, 0, line.length());
            this.bw.newLine();
        }
        catch (Exception e) {
            Log.write("Error writeing line in dtd file");
            Log.write("Exception: " + e);
        }
    }

    public void close() {
        try {
            this.bw.close();
        }
        catch (Exception e) {
            Log.write("Error closeing translated file");
            Log.write("Exception: " + e);
        }
    }
}

