/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.translator.io;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.mozilla.translator.datamodel.LoadedEntry;
import org.mozilla.translator.io.MozReader;
import org.mozilla.translator.kernel.Log;

public class DTDReader
implements MozReader {
    private FileInputStream fis;
    private InputStreamReader isr;
    private BufferedReader br;
    private static final int STATUS_OUTSIDE = 1;
    private static final int STATUS_START = 2;
    private static final int STATUS_COMMENT = 4;
    private static final int STATUS_ENTITY = 3;
    private static final int STATUS_BEFORE = 5;
    private static final int STATUS_KEY = 6;
    private static final int STATUS_BETWEEN = 7;
    private static final int STATUS_VALUE = 8;
    private static final int STATUS_AFTER = 9;
    private boolean opened = true;

    public DTDReader(String fileName) {
        try {
            this.fis = new FileInputStream(fileName);
            this.isr = new InputStreamReader((InputStream)this.fis, "UTF-8");
            this.br = new BufferedReader(this.isr);
        }
        catch (Exception exception) {
            this.opened = false;
        }
    }

    public void open() {
    }

    public LoadedEntry next() {
        LoadedEntry pair;
        char valueLetter = 'x';
        StringBuffer entityBuffer = new StringBuffer(10);
        StringBuffer keyBuffer = new StringBuffer(100);
        StringBuffer valueBuffer = new StringBuffer(1000);
        int status = 1;
        boolean done = false;
        boolean found = false;
        block12: while (!done) {
            int number;
            try {
                number = this.br.read();
            }
            catch (Exception e) {
                Log.write("error during reading dtd file");
                Log.write("Exception: " + e);
                number = -1;
            }
            if (number != -1) {
                char letter = (char)number;
                switch (status) {
                    case 1: {
                        if (letter != '<') continue block12;
                        entityBuffer = new StringBuffer(10);
                        status = 2;
                        break;
                    }
                    case 2: {
                        if (entityBuffer.length() == 7) {
                            if (entityBuffer.toString().equals("!ENTITY")) {
                                status = 3;
                                keyBuffer = new StringBuffer(1000);
                                valueBuffer = new StringBuffer(1000);
                                break;
                            }
                            status = 4;
                            break;
                        }
                        entityBuffer.append(letter);
                        break;
                    }
                    case 4: {
                        if (letter != '>') continue block12;
                        status = 1;
                        break;
                    }
                    case 3: {
                        if (letter == ' ' || letter == '\t') continue block12;
                        keyBuffer.append(letter);
                        status = 6;
                        break;
                    }
                    case 6: {
                        if (letter == ' ' || letter == '\t') {
                            status = 7;
                            break;
                        }
                        keyBuffer.append(letter);
                        break;
                    }
                    case 7: {
                        if (letter != '\"' && letter != '\'') continue block12;
                        status = 8;
                        valueLetter = letter;
                        break;
                    }
                    case 8: {
                        if (letter == valueLetter) {
                            status = 9;
                            break;
                        }
                        valueBuffer.append(letter);
                        break;
                    }
                    case 9: {
                        if (letter != '>') break;
                        done = true;
                        found = true;
                    }
                }
                continue;
            }
            found = false;
            done = true;
        }
        if (found) {
            String key = keyBuffer.toString();
            String value = valueBuffer.toString();
            pair = new LoadedEntry("", key, value);
        } else {
            pair = null;
        }
        return pair;
    }

    public void close() {
        try {
            this.br.close();
        }
        catch (Exception e) {
            Log.write("Error  closing read DTD file");
            Log.write("Exception " + e);
        }
    }
}

