/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.translator.gui.models;

import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.mozilla.translator.datamodel.Phrase;
import org.mozilla.translator.gui.models.ComplexColumn;

public class ComplexTableModel
extends AbstractTableModel {
    private List phrases;
    private List columns;
    private int rows;
    private int cols;

    public ComplexTableModel(List ph, List wCols) {
        this.phrases = ph;
        this.columns = wCols;
        this.rows = this.phrases.size();
        this.cols = this.columns.size();
    }

    public int getRowCount() {
        return this.rows;
    }

    public int getColumnCount() {
        return this.cols;
    }

    public String getColumnName(int index) {
        ComplexColumn cc = (ComplexColumn)this.columns.get(index);
        String result = cc.getName();
        return result;
    }

    public Class getColumnClass(int index) {
        ComplexColumn cc = (ComplexColumn)this.columns.get(index);
        Class result = cc.getColumnClass();
        return result;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        ComplexColumn cc = (ComplexColumn)this.columns.get(columnIndex);
        Phrase ph = (Phrase)this.phrases.get(rowIndex);
        return cc.isEditable(ph);
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        ComplexColumn cc = (ComplexColumn)this.columns.get(columnIndex);
        Phrase ph = (Phrase)this.phrases.get(rowIndex);
        return cc.getValue(ph);
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        ComplexColumn cc = (ComplexColumn)this.columns.get(columnIndex);
        Phrase ph = (Phrase)this.phrases.get(rowIndex);
        cc.setValue(ph, aValue);
    }

    public String getLocaleName() {
        ComplexColumn cc = (ComplexColumn)this.columns.get(0);
        return cc.getLocale();
    }

    public Phrase getRow(int index) {
        return (Phrase)this.phrases.get(index);
    }
}

