/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.translator.gui.models;

import org.mozilla.translator.datamodel.LocalePair;
import org.mozilla.translator.datamodel.Phrase;

public class ComplexColumn {
    public static final int FIELD_KEY = 1;
    public static final int FIELD_ORIGINAL = 2;
    public static final int FIELD_LOCNOTE = 3;
    public static final int FIELD_KEEP_ORIGINAL = 4;
    public static final int FIELD_TRANSLATED = 5;
    public static final int FIELD_QASTATUS = 6;
    public static final int FIELD_QACOMMENT = 7;
    private String localeName;
    private int columnField;

    public ComplexColumn(int cf, String ln) {
        this.columnField = cf;
        this.localeName = ln;
    }

    public String getLocale() {
        return this.localeName;
    }

    public String getName() {
        String result = "error";
        switch (this.columnField) {
            case 1: {
                result = "Key";
                break;
            }
            case 2: {
                result = "Original Text";
                break;
            }
            case 3: {
                result = "Localization note";
                break;
            }
            case 4: {
                result = "Keep Original";
                break;
            }
            case 5: {
                result = "Translated Text";
                break;
            }
            case 6: {
                result = "QA status";
                break;
            }
            case 7: {
                result = "QA comment";
            }
        }
        return result;
    }

    public Class getColumnClass() {
        Class<?> result = null;
        switch (this.columnField) {
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: {
                String stemp = " the class is a string";
                result = stemp.getClass();
                break;
            }
            case 6: {
                Integer itemp = new Integer(1);
                result = itemp.getClass();
                break;
            }
            case 4: {
                Boolean btemp = new Boolean(true);
                result = btemp.getClass();
            }
        }
        return result;
    }

    public boolean isEditable(Phrase p) {
        boolean result = false;
        switch (this.columnField) {
            case 1: 
            case 2: {
                result = false;
                break;
            }
            case 3: 
            case 4: {
                result = true;
                break;
            }
            case 6: 
            case 7: {
                LocalePair pair = p.getLocale(this.localeName);
                if (pair == null) {
                    result = false;
                    break;
                }
                result = true;
                break;
            }
            case 5: {
                result = !p.getKeepOriginal();
            }
        }
        return result;
    }

    public Object getValue(Phrase p) {
        Object result = null;
        LocalePair pair = p.getLocale(this.localeName);
        switch (this.columnField) {
            case 1: {
                result = p.getKey();
                break;
            }
            case 2: {
                result = p.getOriginal();
                break;
            }
            case 3: {
                result = p.getLocNote();
                break;
            }
            case 4: {
                result = new Boolean(p.getKeepOriginal());
                break;
            }
            case 5: {
                if (pair != null) {
                    result = pair.getTranslated();
                    break;
                }
                result = "";
                break;
            }
            case 6: {
                if (pair != null) {
                    result = new Integer(pair.getQaStatus());
                    break;
                }
                result = new Integer(0);
                break;
            }
            case 7: {
                result = pair != null ? pair.getQaComment() : "";
            }
        }
        return result;
    }

    public void setValue(Phrase p, Object value) {
        switch (this.columnField) {
            case 3: {
                String strValue = (String)value;
                p.setLocNote(strValue);
                break;
            }
            case 4: {
                Boolean boolValue = (Boolean)value;
                p.setKeepOriginal(boolValue);
                break;
            }
            case 5: {
                String strValue = (String)value;
                if (!strValue.equals("")) {
                    LocalePair pair = p.getLocale(this.localeName);
                    if (pair == null) {
                        pair = new LocalePair(this.localeName, strValue, 0, "");
                        p.addLocale(pair);
                        break;
                    }
                    pair.setTranslated(strValue);
                    break;
                }
                p.removeLocale(this.localeName);
                break;
            }
            case 6: {
                Integer intValue = (Integer)value;
                LocalePair pair = p.getLocale(this.localeName);
                if (pair == null) break;
                pair.setQaStatus(intValue);
                break;
            }
            case 7: {
                String strValue = (String)value;
                LocalePair pair = p.getLocale(this.localeName);
                if (pair == null) break;
                pair.setQaComment(strValue);
            }
        }
    }
}

