/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.translator.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import org.mozilla.translator.actions.ActivateLocaleAction;
import org.mozilla.translator.actions.ChromeViewAction;
import org.mozilla.translator.actions.EditPhraseAction;
import org.mozilla.translator.actions.ExportGlossaryAction;
import org.mozilla.translator.actions.ExportLocaleAction;
import org.mozilla.translator.actions.FilterAction;
import org.mozilla.translator.actions.ImportGlossaryAction;
import org.mozilla.translator.actions.ImportLocaleAction;
import org.mozilla.translator.actions.PackChromeAction;
import org.mozilla.translator.actions.QaViewAction;
import org.mozilla.translator.actions.QuitAction;
import org.mozilla.translator.actions.ReportRedundantAction;
import org.mozilla.translator.actions.SaveGlossaryAction;
import org.mozilla.translator.actions.SearchViewAction;
import org.mozilla.translator.actions.SummaryAction;
import org.mozilla.translator.actions.UpdateGlossaryAction;
import org.mozilla.translator.actions.ViewKeepAction;
import org.mozilla.translator.actions.ViewRedundantAction;
import org.mozilla.translator.actions.ViewUntranslatedAction;
import org.mozilla.translator.gui.MozFrame;

public class MainWindow
extends JFrame {
    private static MainWindow instance;
    private JLabel statusLine;
    private JDesktopPane desktop;
    private JMenuBar menuBar;
    private JMenu fileMenu;
    private JMenu glossaryMenu;
    private JMenu commandMenu;
    private JMenu viewMenu;
    private JMenu helpMenu;

    public static MainWindow getDefaultInstance() {
        if (instance == null) {
            instance = new MainWindow();
        }
        return instance;
    }

    public MainWindow() {
        super("Mozilla Translator V3");
        this.setDefaultCloseOperation(0);
        this.desktop = new JDesktopPane();
        this.statusLine = new JLabel("Stauts: status not implemented");
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu("File");
        JMenuItem item = this.fileMenu.add(new FilterAction());
        this.fileMenu.addSeparator();
        item = this.fileMenu.add(new QuitAction());
        this.menuBar.add(this.fileMenu);
        this.glossaryMenu = new JMenu("Glossary");
        item = this.glossaryMenu.add(new UpdateGlossaryAction());
        item = this.glossaryMenu.add(new SaveGlossaryAction());
        this.glossaryMenu.addSeparator();
        item = this.glossaryMenu.add(new ImportLocaleAction());
        item = this.glossaryMenu.add(new ExportLocaleAction());
        this.glossaryMenu.addSeparator();
        item = this.glossaryMenu.add(new ImportGlossaryAction());
        item = this.glossaryMenu.add(new ExportGlossaryAction());
        this.menuBar.add(this.glossaryMenu);
        this.commandMenu = new JMenu("Functions");
        item = this.commandMenu.add(new ReportRedundantAction());
        item = this.commandMenu.add(new SummaryAction());
        this.commandMenu.addSeparator();
        item = this.commandMenu.add(new ActivateLocaleAction());
        item = this.commandMenu.add(new PackChromeAction());
        this.commandMenu.addSeparator();
        item = this.commandMenu.add(new EditPhraseAction());
        this.menuBar.add(this.commandMenu);
        this.viewMenu = new JMenu("Views");
        item = this.viewMenu.add(new ChromeViewAction());
        item = this.viewMenu.add(new ViewUntranslatedAction());
        item = this.viewMenu.add(new ViewRedundantAction());
        item = this.viewMenu.add(new ViewKeepAction());
        item = this.viewMenu.add(new QaViewAction());
        item = this.viewMenu.add(new SearchViewAction());
        this.menuBar.add(this.viewMenu);
        this.setJMenuBar(this.menuBar);
        this.getContentPane().add((Component)this.desktop, "Center");
        this.getContentPane().add((Component)this.statusLine, "South");
        ((Component)this).setSize(800, 600);
        this.placeAtCenter();
    }

    public void setStatus(String status) {
        this.statusLine.setText(status);
    }

    public String getStatus() {
        return this.statusLine.getText();
    }

    public void addWindow(JInternalFrame win) {
        this.desktop.add(win);
    }

    private void placeAtCenter() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension scr = tk.getScreenSize();
        Dimension dia = this.getSize();
        int x = (int)(scr.getWidth() / 2.0 - dia.getWidth() / 2.0);
        int y = (int)(scr.getHeight() / 2.0 - dia.getHeight() / 2.0);
        ((Component)this).setLocation(x, y);
    }

    public MozFrame getInnerFrame() {
        return (MozFrame)((Object)this.desktop.getSelectedFrame());
    }
}

