/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.translator.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.mozilla.translator.datamodel.Filter;
import org.mozilla.translator.datamodel.FilterList;
import org.mozilla.translator.gui.EditFilterDialog;
import org.mozilla.translator.gui.MainWindow;
import org.mozilla.translator.kernel.Log;

public class FilterListDialog
extends JDialog {
    private JPanel listPanel;
    private JScrollPane jScrollPane1;
    private JList flist;
    private JPanel adminPanel;
    private JButton addButton;
    private JButton editButton;
    private JButton removeButton;
    private JPanel exitPanel;
    private JButton okayButton;
    private boolean saveList = false;

    public FilterListDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.pack();
        this.placeAtCenter();
    }

    private void initComponents() {
        this.listPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.flist = new JList();
        this.adminPanel = new JPanel();
        this.addButton = new JButton();
        this.editButton = new JButton();
        this.removeButton = new JButton();
        this.exitPanel = new JPanel();
        this.okayButton = new JButton();
        this.setTitle("Filters");
        this.setDefaultCloseOperation(0);
        this.flist.setModel(FilterList.getDefaultInstance());
        this.jScrollPane1.setViewportView(this.flist);
        this.listPanel.add(this.jScrollPane1);
        this.getContentPane().add((Component)this.listPanel, "Center");
        this.adminPanel.setLayout(new GridLayout(3, 1));
        this.addButton.setText("Add");
        this.addButton.addActionListener(new 1());
        this.adminPanel.add(this.addButton);
        this.editButton.setText("Edit");
        this.editButton.addActionListener(new 2());
        this.adminPanel.add(this.editButton);
        this.removeButton.setText("Remove");
        this.removeButton.addActionListener(new 3());
        this.adminPanel.add(this.removeButton);
        this.getContentPane().add((Component)this.adminPanel, "East");
        this.okayButton.setText("Okay");
        this.okayButton.addActionListener(new 4());
        this.exitPanel.add(this.okayButton);
        this.getContentPane().add((Component)this.exitPanel, "South");
    }

    private void okayButtonActionPerformed(ActionEvent evt) {
        ((Component)this).setVisible(false);
    }

    private void removeButtonPressed(ActionEvent evt) {
        FilterList fl = FilterList.getDefaultInstance();
        Filter value = (Filter)this.flist.getSelectedValue();
        fl.removeElement(value);
        this.pack();
    }

    private void editButtonPressed(ActionEvent evt) {
        FilterList fl = FilterList.getDefaultInstance();
        Filter f = (Filter)this.flist.getSelectedValue();
        if (f != null) {
            EditFilterDialog fed = new EditFilterDialog((Frame)MainWindow.getDefaultInstance(), true);
            boolean okayPressed = fed.visDialog(f);
            fl.fyr();
            this.pack();
        }
    }

    private void addButtonPressed(ActionEvent evt) {
        FilterList fl = FilterList.getDefaultInstance();
        Filter f = new Filter("unnamed", 1, 1, "notext");
        EditFilterDialog fed = new EditFilterDialog((Frame)MainWindow.getDefaultInstance(), true);
        boolean okayPressed = fed.visDialog(f);
        if (okayPressed) {
            fl.addElement(f);
        }
        this.pack();
    }

    public void visDialog() {
        Log.write("Setting filter dialog to visible");
        ((Component)this).setVisible(true);
        FilterList fl = FilterList.getDefaultInstance();
        fl.save();
    }

    private void placeAtCenter() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension scr = tk.getScreenSize();
        Dimension dia = this.getSize();
        int x = (int)(scr.getWidth() / 2.0 - dia.getWidth() / 2.0);
        int y = (int)(scr.getHeight() / 2.0 - dia.getHeight() / 2.0);
        ((Component)this).setLocation(x, y);
    }

    private final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            FilterListDialog.this.addButtonPressed(evt);
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            FilterListDialog.this.editButtonPressed(evt);
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            FilterListDialog.this.removeButtonPressed(evt);
        }

        /* synthetic */ 3() {
        }
    }

    private final class 4
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            FilterListDialog.this.okayButtonActionPerformed(evt);
        }

        /* synthetic */ 4() {
        }
    }
}

