/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.translator.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.mozilla.translator.datamodel.LocalePair;
import org.mozilla.translator.datamodel.MozComponent;
import org.mozilla.translator.datamodel.MozFile;
import org.mozilla.translator.datamodel.Phrase;

public class EditPhraseDialog
extends JDialog {
    private boolean okay;
    private JLabel keyLabel;
    private JTextField keyField;
    private JLabel noteLabel;
    private JPanel notePanel;
    private JScrollPane jScrollPane1;
    private JTextArea noteArea;
    private JLabel originalLabel;
    private JPanel originalPanel;
    private JScrollPane jScrollPane2;
    private JTextArea originalArea;
    private JLabel tramslatedLabel;
    private JPanel transaletedPanel;
    private JScrollPane jScrollPane3;
    private JTextArea translatedArea;
    private JLabel statusLabel;
    private JComboBox statusChoice;
    private JLabel commentLabel;
    private JPanel commentPanel;
    private JScrollPane jScrollPane4;
    private JTextArea commentArea;
    private JPanel buttonPanel;
    private JButton okButton;
    private JButton cancelButton;
    private JLabel keepLabel;
    private JCheckBox keepCheck;
    private JLabel componentLabel;
    private JTextField fileField;
    private JLabel fileLabel;
    private JTextField componentField;

    public EditPhraseDialog(Frame parent, boolean modal) {
        super(parent, "Edit Entry", modal);
        this.initComponents();
        this.pack();
        this.placeAtCenter();
    }

    private void initComponents() {
        this.keyLabel = new JLabel();
        this.keyField = new JTextField();
        this.noteLabel = new JLabel();
        this.notePanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.noteArea = new JTextArea();
        this.originalLabel = new JLabel();
        this.originalPanel = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.originalArea = new JTextArea();
        this.tramslatedLabel = new JLabel();
        this.transaletedPanel = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.translatedArea = new JTextArea();
        this.statusLabel = new JLabel();
        String[] modes = new String[]{"Not seen", "Skipped", "Error", "Change", "Accepted", "Perfect", "Other"};
        this.statusChoice = new JComboBox<String>(modes);
        this.commentLabel = new JLabel();
        this.commentPanel = new JPanel();
        this.jScrollPane4 = new JScrollPane();
        this.commentArea = new JTextArea();
        this.buttonPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.keepLabel = new JLabel();
        this.keepCheck = new JCheckBox();
        this.componentLabel = new JLabel();
        this.fileField = new JTextField();
        this.fileLabel = new JLabel();
        this.componentField = new JTextField();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setModal(true);
        this.setDefaultCloseOperation(0);
        this.keyLabel.setText("Key");
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints1.anchor = 13;
        this.getContentPane().add((Component)this.keyLabel, gridBagConstraints1);
        this.keyField.setEditable(false);
        this.keyField.setColumns(30);
        this.keyField.setText("jTextField1");
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.insets = new Insets(0, 5, 5, 0);
        gridBagConstraints1.anchor = 17;
        this.getContentPane().add((Component)this.keyField, gridBagConstraints1);
        this.noteLabel.setText("Localization Note");
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 3;
        gridBagConstraints1.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints1.anchor = 12;
        this.getContentPane().add((Component)this.noteLabel, gridBagConstraints1);
        this.noteArea.setColumns(30);
        this.noteArea.setRows(5);
        this.jScrollPane1.setViewportView(this.noteArea);
        this.notePanel.add(this.jScrollPane1);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 3;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.insets = new Insets(0, 5, 5, 0);
        gridBagConstraints1.anchor = 17;
        this.getContentPane().add((Component)this.notePanel, gridBagConstraints1);
        this.originalLabel.setText("Original text");
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 4;
        gridBagConstraints1.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints1.anchor = 12;
        this.getContentPane().add((Component)this.originalLabel, gridBagConstraints1);
        this.originalArea.setEditable(false);
        this.originalArea.setColumns(30);
        this.originalArea.setRows(5);
        this.jScrollPane2.setViewportView(this.originalArea);
        this.originalPanel.add(this.jScrollPane2);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 4;
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.insets = new Insets(0, 5, 5, 0);
        gridBagConstraints1.anchor = 17;
        this.getContentPane().add((Component)this.originalPanel, gridBagConstraints1);
        this.tramslatedLabel.setText("Translated Area");
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 6;
        gridBagConstraints1.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints1.anchor = 12;
        this.getContentPane().add((Component)this.tramslatedLabel, gridBagConstraints1);
        this.translatedArea.setColumns(30);
        this.translatedArea.setRows(5);
        this.jScrollPane3.setViewportView(this.translatedArea);
        this.transaletedPanel.add(this.jScrollPane3);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 6;
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.insets = new Insets(0, 5, 5, 0);
        gridBagConstraints1.anchor = 17;
        this.getContentPane().add((Component)this.transaletedPanel, gridBagConstraints1);
        this.statusLabel.setText("QA status");
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 7;
        gridBagConstraints1.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints1.anchor = 13;
        this.getContentPane().add((Component)this.statusLabel, gridBagConstraints1);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 7;
        gridBagConstraints1.insets = new Insets(0, 5, 5, 0);
        gridBagConstraints1.anchor = 17;
        this.getContentPane().add((Component)this.statusChoice, gridBagConstraints1);
        this.commentLabel.setText("QA comment");
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 8;
        gridBagConstraints1.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints1.anchor = 12;
        this.getContentPane().add((Component)this.commentLabel, gridBagConstraints1);
        this.commentArea.setColumns(30);
        this.commentArea.setRows(5);
        this.jScrollPane4.setViewportView(this.commentArea);
        this.commentPanel.add(this.jScrollPane4);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 8;
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.insets = new Insets(0, 5, 5, 0);
        gridBagConstraints1.anchor = 17;
        this.getContentPane().add((Component)this.commentPanel, gridBagConstraints1);
        this.okButton.setText("OK");
        this.okButton.addActionListener(new 1());
        this.buttonPanel.add(this.okButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new 2());
        this.buttonPanel.add(this.cancelButton);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 9;
        gridBagConstraints1.fill = 2;
        this.getContentPane().add((Component)this.buttonPanel, gridBagConstraints1);
        this.keepLabel.setText("Original");
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 5;
        gridBagConstraints1.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints1.anchor = 13;
        this.getContentPane().add((Component)this.keepLabel, gridBagConstraints1);
        this.keepCheck.setText("Keep it ?");
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 5;
        gridBagConstraints1.insets = new Insets(0, 5, 5, 0);
        gridBagConstraints1.anchor = 17;
        this.getContentPane().add((Component)this.keepCheck, gridBagConstraints1);
        this.componentLabel.setText("Component");
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints1.anchor = 13;
        this.getContentPane().add((Component)this.componentLabel, gridBagConstraints1);
        this.fileField.setEditable(false);
        this.fileField.setColumns(30);
        this.fileField.setText("jTextField2");
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.insets = new Insets(0, 5, 5, 0);
        gridBagConstraints1.anchor = 17;
        this.getContentPane().add((Component)this.fileField, gridBagConstraints1);
        this.fileLabel.setText("File");
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints1.anchor = 13;
        this.getContentPane().add((Component)this.fileLabel, gridBagConstraints1);
        this.componentField.setEditable(false);
        this.componentField.setColumns(30);
        this.componentField.setText("jTextField3");
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.insets = new Insets(0, 5, 5, 0);
        gridBagConstraints1.anchor = 17;
        this.getContentPane().add((Component)this.componentField, gridBagConstraints1);
    }

    private void cancelButtonPressed(ActionEvent evt) {
        this.okay = false;
        ((Component)this).setVisible(false);
    }

    private void okButtonPressed(ActionEvent evt) {
        this.okay = true;
        ((Component)this).setVisible(false);
    }

    public void visDialog(Phrase p, String localeName) {
        this.okay = false;
        MozFile mf = p.getFile();
        MozComponent mc = mf.getComponent();
        LocalePair pair = p.getLocale(localeName);
        this.componentField.setText(mc.toString());
        this.fileField.setText(mf.toString());
        this.keyField.setText(p.getKey());
        this.noteArea.setText(p.getLocNote());
        this.originalArea.setText(p.getOriginal());
        this.keepCheck.setSelected(p.getKeepOriginal());
        if (pair != null) {
            this.translatedArea.setText(pair.getTranslated());
            this.commentArea.setText(pair.getQaComment());
            this.statusChoice.setSelectedIndex(pair.getQaStatus());
        } else {
            this.translatedArea.setText("");
            this.commentArea.setText("");
            this.statusChoice.setSelectedIndex(0);
        }
        ((Component)this).setVisible(true);
        if (this.okay) {
            p.setLocNote(this.noteArea.getText());
            p.setKeepOriginal(this.keepCheck.isSelected());
            if (pair != null) {
                pair.setTranslated(this.translatedArea.getText());
                pair.setQaComment(this.commentArea.getText());
                pair.setQaStatus(this.statusChoice.getSelectedIndex());
            } else {
                pair = new LocalePair(localeName, this.translatedArea.getText(), this.statusChoice.getSelectedIndex(), this.commentArea.getText());
                p.addLocale(pair);
            }
        }
    }

    private void placeAtCenter() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension scr = tk.getScreenSize();
        Dimension dia = this.getSize();
        int x = (int)(scr.getWidth() / 2.0 - dia.getWidth() / 2.0);
        int y = (int)(scr.getHeight() / 2.0 - dia.getHeight() / 2.0);
        ((Component)this).setLocation(x, y);
    }

    private final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            EditPhraseDialog.this.okButtonPressed(evt);
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            EditPhraseDialog.this.cancelButtonPressed(evt);
        }

        /* synthetic */ 2() {
        }
    }
}

