/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.translator.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.mozilla.translator.datamodel.Filter;

public class EditFilterDialog
extends JDialog {
    private JPanel jPanel1;
    private JLabel titleLabel;
    private JTextField titleField;
    private JLabel fieldLabel;
    private JComboBox fieldComboBox;
    private JLabel ruleLabel;
    private JComboBox ruleComboBox;
    private JLabel textLabel;
    private JTextField textField;
    private JPanel jPanel2;
    private JButton okayButton;
    private JButton cancelButton;
    private boolean okayed;

    public EditFilterDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.pack();
        this.placeAtCenter();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.titleLabel = new JLabel();
        this.titleField = new JTextField();
        this.fieldLabel = new JLabel();
        String[] keys = new String[]{"Key", "orginal"};
        this.fieldComboBox = new JComboBox<String>(keys);
        this.ruleLabel = new JLabel();
        String[] rules = new String[]{"Equals", "Contains", "Starts with", "Ends with"};
        this.ruleComboBox = new JComboBox<String>(rules);
        this.textLabel = new JLabel();
        this.textField = new JTextField();
        this.jPanel2 = new JPanel();
        this.okayButton = new JButton();
        this.cancelButton = new JButton();
        this.setTitle("Edit Filter");
        this.setDefaultCloseOperation(0);
        this.jPanel1.setLayout(new GridLayout(4, 2));
        this.titleLabel.setText("Title");
        this.jPanel1.add(this.titleLabel);
        this.titleField.setColumns(20);
        this.titleField.setText("Title goes here");
        this.jPanel1.add(this.titleField);
        this.fieldLabel.setText("Field");
        this.jPanel1.add(this.fieldLabel);
        this.jPanel1.add(this.fieldComboBox);
        this.ruleLabel.setText("Rule");
        this.jPanel1.add(this.ruleLabel);
        this.jPanel1.add(this.ruleComboBox);
        this.textLabel.setText("Text");
        this.jPanel1.add(this.textLabel);
        this.textField.setText("jTextField2");
        this.jPanel1.add(this.textField);
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.okayButton.setText("Okay");
        this.okayButton.addActionListener(new 1());
        this.jPanel2.add(this.okayButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new 2());
        this.jPanel2.add(this.cancelButton);
        this.getContentPane().add((Component)this.jPanel2, "South");
    }

    private void okayButtonActionPerformed(ActionEvent evt) {
        this.okayed = true;
        ((Component)this).setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.okayed = false;
        ((Component)this).setVisible(false);
    }

    public boolean visDialog(Filter filt) {
        this.okayed = false;
        this.titleField.setText(filt.getTitle());
        this.textField.setText(filt.getText());
        int what = filt.getField();
        switch (what) {
            case 1: {
                this.fieldComboBox.setSelectedIndex(0);
                break;
            }
            case 2: {
                this.fieldComboBox.setSelectedIndex(1);
            }
        }
        what = filt.getRule();
        switch (what) {
            case 1: {
                this.ruleComboBox.setSelectedIndex(0);
                break;
            }
            case 2: {
                this.ruleComboBox.setSelectedIndex(1);
                break;
            }
            case 3: {
                this.ruleComboBox.setSelectedIndex(2);
                break;
            }
            case 4: {
                this.ruleComboBox.setSelectedIndex(3);
            }
        }
        ((Component)this).setVisible(true);
        if (this.okayed) {
            filt.setTitle(this.titleField.getText());
            filt.setText(this.textField.getText());
            switch (this.fieldComboBox.getSelectedIndex()) {
                case 0: {
                    filt.setField(1);
                    break;
                }
                case 1: {
                    filt.setField(2);
                }
            }
            switch (this.ruleComboBox.getSelectedIndex()) {
                case 0: {
                    filt.setRule(1);
                    break;
                }
                case 1: {
                    filt.setRule(2);
                    break;
                }
                case 2: {
                    filt.setRule(3);
                    break;
                }
                case 3: {
                    filt.setRule(4);
                }
            }
        }
        this.dispose();
        return this.okayed;
    }

    public static void main(String[] args) {
        new EditFilterDialog((Frame)new JFrame(), true).show();
    }

    private void placeAtCenter() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension scr = tk.getScreenSize();
        Dimension dia = this.getSize();
        int x = (int)(scr.getWidth() / 2.0 - dia.getWidth() / 2.0);
        int y = (int)(scr.getHeight() / 2.0 - dia.getHeight() / 2.0);
        ((Component)this).setLocation(x, y);
    }

    private final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            EditFilterDialog.this.okayButtonActionPerformed(evt);
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            EditFilterDialog.this.cancelButtonActionPerformed(evt);
        }

        /* synthetic */ 2() {
        }
    }
}

