/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.translator.gui;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JInternalFrame;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.mozilla.translator.datamodel.Glossary;
import org.mozilla.translator.datamodel.MozComponent;
import org.mozilla.translator.datamodel.MozFile;
import org.mozilla.translator.datamodel.Phrase;
import org.mozilla.translator.gui.MainWindow;
import org.mozilla.translator.gui.MozFrame;
import org.mozilla.translator.gui.models.ComplexTableModel;

public class ChromeView
extends JInternalFrame
implements TreeSelectionListener,
MozFrame {
    private List cols;
    private ComplexTableModel model;
    private JTree tree;
    private JTable table;
    private DefaultMutableTreeNode root;
    private JScrollPane treeScroll;
    private JScrollPane tableScroll;
    private JSplitPane split;
    private String localeName;

    public ChromeView(List wCols, String l) {
        super("Chrome view for " + l);
        this.cols = wCols;
        this.setClosable(true);
        this.setMaximizable(true);
        this.setIconifiable(true);
        this.setResizable(true);
        this.localeName = l;
        Glossary glos = Glossary.getDefaultInstance();
        this.root = new DefaultMutableTreeNode("chrome: " + this.localeName);
        List compList = glos.getAllComponents();
        Iterator compIterator = compList.iterator();
        while (compIterator.hasNext()) {
            MozComponent currentComponent = (MozComponent)compIterator.next();
            DefaultMutableTreeNode currentCompNode = new DefaultMutableTreeNode(currentComponent);
            this.root.add(currentCompNode);
            List fileList = currentComponent.getAllFiles();
            Iterator fileIterator = fileList.iterator();
            while (fileIterator.hasNext()) {
                MozFile currentFile = (MozFile)fileIterator.next();
                DefaultMutableTreeNode currentFileNode = new DefaultMutableTreeNode(currentFile);
                currentCompNode.add(currentFileNode);
            }
        }
        Phrase noLoaded = new Phrase("Nothing chosen", "Nothing chosen", "", null);
        ArrayList<Phrase> noLoadedList = new ArrayList<Phrase>();
        noLoadedList.add(noLoaded);
        this.tree = new JTree(this.root);
        this.tree.addTreeSelectionListener(this);
        this.treeScroll = new JScrollPane(this.tree);
        this.model = new ComplexTableModel(noLoadedList, this.cols);
        this.table = new JTable(this.model);
        this.tableScroll = new JScrollPane(this.table);
        this.split = new JSplitPane(1, this.treeScroll, this.tableScroll);
        this.getContentPane().add((Component)this.split, "Center");
        this.pack();
        MainWindow.getDefaultInstance().addWindow(this);
        this.setVisible(true);
    }

    public void valueChanged(TreeSelectionEvent evt) {
        TreePath tp = evt.getNewLeadSelectionPath();
        int pathCount = tp.getPathCount();
        if (pathCount == 3) {
            DefaultMutableTreeNode lastNode = (DefaultMutableTreeNode)tp.getLastPathComponent();
            MozFile theFile = (MozFile)lastNode.getUserObject();
            List ps = theFile.getAllPhrases();
            this.model = new ComplexTableModel(ps, this.cols);
            this.table.setModel(this.model);
        }
    }

    public Phrase getSelectedPhrase() {
        int rowIndex = this.table.getSelectedRow();
        return this.model.getRow(rowIndex);
    }

    public String getLocaleName() {
        return this.localeName;
    }
}

