/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.translator.datamodel;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.mozilla.translator.datamodel.LocalePair;
import org.mozilla.translator.datamodel.MozFile;

public class Phrase
implements Comparable {
    private MozFile file;
    private String key;
    private String original;
    private String locNote;
    private boolean keepOriginal;
    private List translations;
    private boolean marked = false;

    public Phrase(String k, String o, String n, MozFile f) {
        this.key = k;
        this.file = f;
        this.original = o;
        this.locNote = n;
        this.translations = new ArrayList();
    }

    public int compareTo(Object other) {
        Phrase pOther = (Phrase)other;
        return this.key.compareTo(pOther.key);
    }

    public String getKey() {
        return this.key;
    }

    public String getOriginal() {
        return this.original;
    }

    public String getLocNote() {
        return this.locNote;
    }

    public MozFile getFile() {
        return this.file;
    }

    public void setOriginal(String value) {
        this.original = value;
    }

    public void setLocNote(String value) {
        this.locNote = value;
    }

    public void addLocale(LocalePair nLocale) {
        this.translations.add(nLocale);
    }

    public void removeLocale(String localeName) {
        Iterator i = this.translations.iterator();
        boolean done = false;
        while (i.hasNext() && !done) {
            LocalePair test = (LocalePair)i.next();
            if (!test.isLocale(localeName)) continue;
            i.remove();
            done = true;
        }
    }

    public LocalePair getLocale(String localeName) {
        LocalePair result = null;
        LocalePair test = null;
        Iterator i = this.translations.iterator();
        boolean done = false;
        while (i.hasNext() && !done) {
            test = (LocalePair)i.next();
            if (!test.isLocale(localeName)) continue;
            result = test;
            done = true;
        }
        return result;
    }

    public List getAllLocales() {
        return this.translations;
    }

    public boolean getMarked() {
        return this.marked;
    }

    public void setMarked(boolean value) {
        this.marked = value;
    }

    public boolean isPhrase(String otherKey) {
        return this.key.equals(otherKey);
    }

    public String toString() {
        return this.key;
    }

    public boolean getKeepOriginal() {
        return this.keepOriginal;
    }

    public void setKeepOriginal(boolean value) {
        this.keepOriginal = value;
    }
}

