/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.translator.datamodel;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.mozilla.translator.datamodel.MozComponent;
import org.mozilla.translator.datamodel.Phrase;
import org.mozilla.translator.io.DTDReader;
import org.mozilla.translator.io.DTDWriter;
import org.mozilla.translator.io.MozReader;
import org.mozilla.translator.io.MozWriter;
import org.mozilla.translator.io.PropertiesReader;
import org.mozilla.translator.io.PropertiesWriter;
import org.mozilla.translator.kernel.Settings;

public class MozFile
implements Comparable {
    private static final int TYPE_DTD = 1;
    private static final int TYPE_PROP = 2;
    private String name;
    private int type;
    private MozComponent component;
    private List phrases;
    private boolean marked = false;

    public MozFile(String n, MozComponent c) {
        this.name = n;
        this.type = n.endsWith(".dtd") ? 1 : 2;
        this.component = c;
        this.phrases = new ArrayList();
    }

    public MozFile(String n, int t, MozComponent c) {
        this.name = n;
        this.type = t;
        this.component = c;
        this.phrases = new ArrayList();
    }

    public int compareTo(Object other) {
        MozFile fOther = (MozFile)other;
        return this.name.compareTo(fOther.name);
    }

    public void setMarked(boolean value) {
        this.marked = value;
    }

    public boolean getMarked() {
        return this.marked;
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public MozComponent getComponent() {
        return this.component;
    }

    public void addPhrase(Phrase p) {
        this.phrases.add(p);
    }

    public void removePhrase(String phraseKey) {
        Iterator i = this.phrases.iterator();
        boolean done = false;
        while (i.hasNext() && !done) {
            Phrase test = (Phrase)i.next();
            if (!test.isPhrase(phraseKey)) continue;
            i.remove();
            done = true;
        }
    }

    public Phrase getPhrase(String phraseKey) {
        Phrase result = null;
        Phrase test = null;
        Iterator i = this.phrases.iterator();
        boolean done = false;
        while (i.hasNext() && !done) {
            test = (Phrase)i.next();
            if (!test.isPhrase(phraseKey)) continue;
            result = test;
            done = true;
        }
        return result;
    }

    public List getAllPhrases() {
        return this.phrases;
    }

    public boolean isFile(String othername) {
        return this.name.equals(othername);
    }

    public MozReader getReader(String localeName) {
        MozReader result = null;
        String baseDir = Settings.getString("mozilla.chromedir");
        String componentName = this.component.getName();
        String filename = String.valueOf(baseDir) + File.separator + componentName;
        filename = String.valueOf(filename) + File.separator + "locale";
        filename = String.valueOf(filename) + File.separator + localeName;
        File testFile = new File(filename = String.valueOf(filename) + File.separator + this.name);
        if (testFile.exists()) {
            switch (this.type) {
                case 1: {
                    result = new DTDReader(filename);
                    break;
                }
                case 2: {
                    result = new PropertiesReader(filename);
                }
            }
        } else {
            result = null;
        }
        return result;
    }

    public MozWriter getWriter(String localeName) {
        MozWriter result = null;
        String baseDir = Settings.getString("mozilla.chromedir");
        String componentName = this.component.getName();
        String filename = String.valueOf(baseDir) + File.separator + componentName;
        filename = String.valueOf(filename) + File.separator + "locale";
        filename = String.valueOf(filename) + File.separator + localeName;
        filename = String.valueOf(filename) + File.separator + this.name;
        switch (this.type) {
            case 1: {
                result = new DTDWriter(filename);
                break;
            }
            case 2: {
                result = new PropertiesWriter(filename);
            }
        }
        return result;
    }

    public String toString() {
        return this.name;
    }
}

