/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.translator.datamodel;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.mozilla.translator.datamodel.FilterList;
import org.mozilla.translator.datamodel.LoadedEntry;
import org.mozilla.translator.datamodel.LocalePair;
import org.mozilla.translator.datamodel.MozComponent;
import org.mozilla.translator.datamodel.MozFile;
import org.mozilla.translator.datamodel.Phrase;
import org.mozilla.translator.gui.MainWindow;
import org.mozilla.translator.gui.OutputWindow;
import org.mozilla.translator.io.MozReader;
import org.mozilla.translator.io.MozWriter;
import org.mozilla.translator.kernel.Log;
import org.mozilla.translator.kernel.Settings;

public class Glossary {
    private static Glossary instance;
    private List components;

    public static Glossary getDefaultInstance() {
        if (instance == null) {
            instance = new Glossary();
        }
        return instance;
    }

    public Glossary() {
        String name = Settings.getString("glossary.filename");
        File file = new File(name);
        this.components = new ArrayList();
        if (file.exists()) {
            this.load();
        } else {
            this.update();
        }
    }

    public MozComponent getComponent(String filename) {
        MozComponent result = null;
        MozComponent test = null;
        Iterator i = this.components.iterator();
        boolean done = false;
        while (i.hasNext() && !done) {
            test = (MozComponent)i.next();
            if (!test.isComponent(filename)) continue;
            result = test;
            done = true;
        }
        return result;
    }

    public List getAllComponents() {
        return this.components;
    }

    public void load() {
        Properties prop = new Properties();
        try {
            FileInputStream fis = new FileInputStream(Settings.getString("glossary.filename"));
            ZipInputStream zis = new ZipInputStream(fis);
            ZipEntry ze = zis.getNextEntry();
            prop.load(zis);
            zis.closeEntry();
            zis.close();
            int componentCount = Integer.parseInt(prop.getProperty("componentCount"));
            int c = 0;
            while (c < componentCount) {
                String compNumber = "" + c;
                String componentName = prop.getProperty(compNumber + ".name");
                MozComponent currentComponent = new MozComponent(componentName);
                this.components.add(currentComponent);
                int fileCount = Integer.parseInt(prop.getProperty(compNumber + ".fileCount"));
                int f = 0;
                while (f < fileCount) {
                    String fileNumber = compNumber + "." + f;
                    String fileName = prop.getProperty(fileNumber + ".name");
                    int fileType = Integer.parseInt(prop.getProperty(fileNumber + ".type"));
                    MozFile currentFile = new MozFile(fileName, fileType, currentComponent);
                    currentComponent.addFile(currentFile);
                    int phraseCount = Integer.parseInt(prop.getProperty(fileNumber + ".phraseCount"));
                    int p = 0;
                    while (p < phraseCount) {
                        String phraseNumber = fileNumber + "." + p;
                        String key = prop.getProperty(phraseNumber + ".key");
                        String original = prop.getProperty(phraseNumber + ".original");
                        String note = prop.getProperty(phraseNumber + ".note", "");
                        String keepString = prop.getProperty(phraseNumber + ".keep", "false");
                        Boolean keepBool = new Boolean(keepString);
                        boolean keep = keepBool;
                        Phrase currentPhrase = new Phrase(key, original, note, currentFile);
                        currentPhrase.setKeepOriginal(keep);
                        currentFile.addPhrase(currentPhrase);
                        String locales = prop.getProperty(phraseNumber + ".locales", "NONE");
                        if (!locales.equals("NONE")) {
                            StringTokenizer localeTokenizer = new StringTokenizer(locales, ",", false);
                            while (localeTokenizer.hasMoreTokens()) {
                                String singleLocale = localeTokenizer.nextToken();
                                String localeNumber = phraseNumber + "." + singleLocale;
                                String translated = prop.getProperty(localeNumber + ".text");
                                int qa = Integer.parseInt(prop.getProperty(localeNumber + ".qa", "0"));
                                String comment = prop.getProperty(localeNumber + ".comment", "");
                                LocalePair currentPair = new LocalePair(singleLocale, translated, qa, comment);
                                currentPhrase.addLocale(currentPair);
                            }
                        }
                        ++p;
                    }
                    Collections.sort(currentFile.getAllPhrases());
                    ++f;
                }
                Collections.sort(currentComponent.getAllFiles());
                ++c;
            }
            Collections.sort(this.components);
        }
        catch (IOException e) {
            Log.write("Error loading gloassary file");
        }
    }

    public void save() {
        MainWindow.getDefaultInstance().setStatus("Saving Glossary");
        Properties prop = new Properties();
        try {
            Iterator componentIterator = this.components.iterator();
            int componentCount = this.components.size();
            prop.setProperty("componentCount", "" + componentCount);
            int componentCounter = 0;
            while (componentIterator.hasNext()) {
                MozComponent currentComponent = (MozComponent)componentIterator.next();
                String componentName = currentComponent.getName();
                String compNumber = "" + componentCounter;
                prop.setProperty(compNumber + ".name", componentName);
                List fileList = currentComponent.getAllFiles();
                Iterator fileIterator = fileList.iterator();
                int fileCount = fileList.size();
                prop.setProperty(compNumber + ".fileCount", "" + fileCount);
                int fileCounter = 0;
                while (fileIterator.hasNext()) {
                    MozFile currentFile = (MozFile)fileIterator.next();
                    String fileNumber = compNumber + "." + fileCounter;
                    String fileName = currentFile.getName();
                    prop.setProperty(fileNumber + ".name", fileName);
                    int fileType = currentFile.getType();
                    prop.setProperty(fileNumber + ".type", "" + fileType);
                    List phraseList = currentFile.getAllPhrases();
                    Iterator phraseIterator = phraseList.iterator();
                    int phraseCount = phraseList.size();
                    prop.setProperty(fileNumber + ".phraseCount", "" + phraseCount);
                    int phraseCounter = 0;
                    while (phraseIterator.hasNext()) {
                        boolean keep;
                        Phrase currentPhrase = (Phrase)phraseIterator.next();
                        String phraseNumber = fileNumber + "." + phraseCounter;
                        String locales = "";
                        List localeList = currentPhrase.getAllLocales();
                        Iterator localeIterator = localeList.iterator();
                        String key = currentPhrase.getKey();
                        prop.setProperty(phraseNumber + ".key", key);
                        String original = currentPhrase.getOriginal();
                        prop.setProperty(phraseNumber + ".original", original);
                        String note = currentPhrase.getLocNote();
                        if (!note.equals("")) {
                            prop.setProperty(phraseNumber + ".note", note);
                        }
                        if (keep = currentPhrase.getKeepOriginal()) {
                            prop.setProperty(phraseNumber + ".keep", "true");
                        }
                        while (localeIterator.hasNext()) {
                            int qa;
                            if (locales.length() > 1) {
                                locales = locales + ",";
                            }
                            LocalePair currentLocale = (LocalePair)localeIterator.next();
                            String localeName = currentLocale.getLocale();
                            locales = locales + localeName;
                            String localeNumber = phraseNumber + "." + localeName;
                            String translated = currentLocale.getTranslated();
                            prop.setProperty(localeNumber + ".text", translated);
                            String comment = currentLocale.getQaComment();
                            if (!comment.equals("")) {
                                prop.setProperty(localeNumber + ".comment", comment);
                            }
                            if ((qa = currentLocale.getQaStatus()) == 0) continue;
                            prop.setProperty(localeNumber + ".qa", "" + qa);
                        }
                        if (locales.length() > 1) {
                            prop.setProperty(phraseNumber + ".locales", locales);
                        }
                        ++phraseCounter;
                    }
                    ++fileCounter;
                }
                ++componentCounter;
            }
            FileOutputStream fos = new FileOutputStream(Settings.getString("glossary.filename"));
            ZipOutputStream zos = new ZipOutputStream(fos);
            ZipEntry ze = new ZipEntry("glossary.txt");
            zos.putNextEntry(ze);
            prop.store(zos, "Glossary file for MozillaTranslator");
            zos.closeEntry();
            zos.close();
        }
        catch (IOException e) {
            Log.write("Error saving glossary");
        }
        MainWindow.getDefaultInstance().setStatus("Done saving glossary");
    }

    public void update() {
        Phrase currentPhrase;
        MozFile currentFile;
        MozComponent currentComponent;
        String baseDirString = Settings.getString("mozilla.chromedir");
        File baseDirFile = new File(baseDirString);
        OutputWindow ow = new OutputWindow("Updateing the Glossary");
        String[] componentDirs = baseDirFile.list();
        int c = 0;
        while (c < componentDirs.length) {
            String isDirectoryString = baseDirString + File.separator + componentDirs[c];
            File isDirectoryFile = new File(isDirectoryString);
            if (isDirectoryFile.isDirectory()) {
                String componentDirString = isDirectoryString + File.separator + "locale";
                File componentDirFile = new File(componentDirString = componentDirString + File.separator + "en-US");
                String[] files = componentDirFile.list();
                if (files != null) {
                    currentComponent = this.getComponent(componentDirs[c]);
                    if (currentComponent == null) {
                        ow.append("\nAdding Component + " + componentDirs[c]);
                        currentComponent = new MozComponent(componentDirs[c]);
                        this.components.add(currentComponent);
                    }
                    currentComponent.setMarked(true);
                    int f = 0;
                    while (f < files.length) {
                        currentFile = currentComponent.getFile(files[f]);
                        if (currentFile == null) {
                            ow.append("\nIn " + currentComponent + " I added the  file + " + currentFile);
                            currentFile = new MozFile(files[f], currentComponent);
                            currentComponent.addFile(currentFile);
                        }
                        currentFile.setMarked(true);
                        MozReader reader = currentFile.getReader("en-US");
                        reader.open();
                        boolean done = false;
                        while (!done) {
                            LoadedEntry currentEntry = reader.next();
                            if (currentEntry == null) {
                                done = true;
                                continue;
                            }
                            currentPhrase = currentFile.getPhrase(currentEntry.getKey());
                            if (currentPhrase == null) {
                                ow.append("\nIn " + currentComponent + " -> " + currentFile + " I added the phrase:  " + currentEntry.getKey());
                                currentPhrase = new Phrase(currentEntry.getKey(), currentEntry.getText(), currentEntry.getNote(), currentFile);
                                currentPhrase.setKeepOriginal(FilterList.getDefaultInstance().check(currentPhrase));
                                currentFile.addPhrase(currentPhrase);
                            } else {
                                if (!currentPhrase.getOriginal().equals(currentEntry.getText())) {
                                    ow.append("\n" + currentComponent + " -> " + currentFile + " -> " + currentPhrase + " has changed text");
                                } else if (!currentPhrase.getLocNote().equals(currentEntry.getNote())) {
                                    ow.append("\n" + currentComponent + " -> " + currentFile + " -> " + currentPhrase + " has changed localization note");
                                }
                                currentPhrase.setOriginal(currentEntry.getText());
                                currentPhrase.setLocNote(currentEntry.getNote());
                            }
                            currentPhrase.setMarked(true);
                        }
                        reader.close();
                        ++f;
                    }
                }
            }
            ++c;
        }
        ow.append("\n\n\n");
        Iterator componentIterator = this.components.iterator();
        while (componentIterator.hasNext()) {
            currentComponent = (MozComponent)componentIterator.next();
            if (currentComponent.getMarked()) {
                currentComponent.setMarked(false);
                List fileList = currentComponent.getAllFiles();
                Iterator fileIterator = fileList.iterator();
                while (fileIterator.hasNext()) {
                    currentFile = (MozFile)fileIterator.next();
                    if (currentFile.getMarked()) {
                        currentFile.setMarked(false);
                        List phraseList = currentFile.getAllPhrases();
                        Iterator phraseIterator = phraseList.iterator();
                        while (phraseIterator.hasNext()) {
                            currentPhrase = (Phrase)phraseIterator.next();
                            if (currentPhrase.getMarked()) {
                                currentPhrase.setMarked(true);
                                continue;
                            }
                            ow.append("\nRemoving phrase: " + currentPhrase + " from " + currentComponent + " -> " + currentFile);
                            phraseIterator.remove();
                        }
                        continue;
                    }
                    ow.append("\nRemoving file: " + currentFile + " from " + currentComponent);
                    fileIterator.remove();
                }
                continue;
            }
            ow.append("\nRemoving component: " + currentComponent);
            componentIterator.remove();
        }
        ow.setVisible(true);
    }

    public void importLocale(String localeName) {
        Iterator componentIterator = this.components.iterator();
        while (componentIterator.hasNext()) {
            MozComponent currentComponent = (MozComponent)componentIterator.next();
            List fileList = currentComponent.getAllFiles();
            Iterator fileIterator = fileList.iterator();
            while (fileIterator.hasNext()) {
                MozFile currentFile = (MozFile)fileIterator.next();
                MozReader reader = currentFile.getReader(localeName);
                if (reader == null) continue;
                reader.open();
                boolean done = false;
                while (!done) {
                    LoadedEntry loaded = reader.next();
                    if (loaded == null) {
                        done = true;
                        continue;
                    }
                    String loadedKey = loaded.getKey();
                    Phrase currentPhrase = currentFile.getPhrase(loadedKey);
                    if (currentPhrase == null || currentPhrase.getKeepOriginal()) continue;
                    LocalePair currentLocale = currentPhrase.getLocale(localeName);
                    if (currentLocale == null) {
                        currentLocale = new LocalePair(localeName, loaded.getText(), 0, "");
                        currentPhrase.addLocale(currentLocale);
                        continue;
                    }
                    currentLocale.setQaStatus(0);
                    currentLocale.setTranslated(loaded.getText());
                    currentLocale.setQaComment("");
                }
                reader.close();
            }
        }
    }

    public void exportLocale(String localeName) {
        OutputWindow ow = new OutputWindow("Exporting locale: " + localeName);
        Iterator componentIterator = this.components.iterator();
        while (componentIterator.hasNext()) {
            MozComponent currentComponent = (MozComponent)componentIterator.next();
            List fileList = currentComponent.getAllFiles();
            Iterator fileIterator = fileList.iterator();
            while (fileIterator.hasNext()) {
                MozFile currentFile = (MozFile)fileIterator.next();
                List phraseList = currentFile.getAllPhrases();
                Iterator phraseIterator = phraseList.iterator();
                MozWriter writer = currentFile.getWriter(localeName);
                writer.open();
                while (phraseIterator.hasNext()) {
                    String text;
                    Phrase currentPhrase = (Phrase)phraseIterator.next();
                    if (currentPhrase.getKeepOriginal()) {
                        text = currentPhrase.getOriginal();
                    } else {
                        LocalePair currentLocale = currentPhrase.getLocale(localeName);
                        if (currentLocale == null) {
                            ow.append("\n\n** Warning: key not translated **");
                            ow.append("\nComponent = " + currentComponent.getName());
                            ow.append("\nFile =" + currentFile.getName());
                            ow.append("\nKey  =" + currentPhrase.getKey());
                            text = currentPhrase.getOriginal();
                        } else {
                            text = currentLocale.getTranslated();
                        }
                    }
                    String key = currentPhrase.getKey();
                    writer.next(key, text);
                }
                writer.close();
            }
        }
        ow.append("\n\nDONE!!");
        ow.setVisible(true);
    }

    public void importGlossary(String fn, String localeName) {
        Properties prop = new Properties();
        boolean componentCounter = false;
        boolean fileCounter = false;
        boolean phraseCounter = false;
        try {
            FileInputStream fis = new FileInputStream(fn);
            ZipInputStream zis = new ZipInputStream(fis);
            ZipEntry ze = zis.getNextEntry();
            prop.load(zis);
            zis.closeEntry();
            zis.close();
            int maxComponent = Integer.parseInt(prop.getProperty("componentCount"));
            int c = 0;
            while (c < maxComponent) {
                String componentNumber = "" + c;
                String compName = prop.getProperty(componentNumber + ".name");
                MozComponent currentComponent = this.getComponent(compName);
                if (currentComponent != null) {
                    int maxFile = Integer.parseInt(prop.getProperty(componentNumber + ".fileCount"));
                    int f = 0;
                    while (f < maxFile) {
                        String fileNumber = componentNumber + "." + f;
                        String fileName = prop.getProperty(fileNumber + ".name");
                        MozFile currentFile = currentComponent.getFile(fileName);
                        if (currentFile != null) {
                            int maxPhrase = Integer.parseInt(prop.getProperty(fileNumber + ".phraseCount"));
                            int p = 0;
                            while (p < maxPhrase) {
                                String phraseNumber = fileNumber + "." + p;
                                String phraseName = prop.getProperty(phraseNumber + ".key");
                                Phrase currentPhrase = currentFile.getPhrase(phraseName);
                                if (currentPhrase != null) {
                                    String translatedText = prop.getProperty(phraseNumber + ".text");
                                    String comment = prop.getProperty(phraseNumber + ".comment", "");
                                    int status = Integer.parseInt(prop.getProperty(phraseNumber + ".qa", "0"));
                                    LocalePair currentLocale = currentPhrase.getLocale(localeName);
                                    if (currentLocale != null) {
                                        currentLocale.setTranslated(translatedText);
                                        currentLocale.setQaComment(comment);
                                        currentLocale.setQaStatus(status);
                                    } else {
                                        currentLocale = new LocalePair(localeName, translatedText, status, comment);
                                        currentPhrase.addLocale(currentLocale);
                                    }
                                }
                                ++p;
                            }
                        }
                        ++f;
                    }
                }
                ++c;
            }
        }
        catch (IOException e) {
            Log.write("error importing glossary");
        }
    }

    public void exportGlossary(String fn, String localeName) {
        Properties prop = new Properties();
        int componentCounter = -1;
        int fileCounter = -1;
        int phraseCounter = -1;
        Iterator componentIterator = this.components.iterator();
        while (componentIterator.hasNext()) {
            boolean firstComponent = true;
            MozComponent currentComponent = (MozComponent)componentIterator.next();
            List fileList = currentComponent.getAllFiles();
            Iterator fileIterator = fileList.iterator();
            fileCounter = -1;
            while (fileIterator.hasNext()) {
                boolean firstFile = true;
                MozFile currentFile = (MozFile)fileIterator.next();
                List phraseList = currentFile.getAllPhrases();
                Iterator phraseIterator = phraseList.iterator();
                phraseCounter = -1;
                while (phraseIterator.hasNext()) {
                    Phrase currentPhrase = (Phrase)phraseIterator.next();
                    LocalePair currentLocale = currentPhrase.getLocale(localeName);
                    if (currentLocale == null) continue;
                    if (firstComponent) {
                        firstComponent = false;
                        prop.setProperty("" + ++componentCounter + ".name", currentComponent.getName());
                    }
                    if (firstFile) {
                        firstFile = false;
                        prop.setProperty("" + componentCounter + "." + ++fileCounter + ".name", currentFile.getName());
                    }
                    prop.setProperty("" + componentCounter + "." + fileCounter + "." + ++phraseCounter + ".key", currentPhrase.getKey());
                    prop.setProperty("" + componentCounter + "." + fileCounter + "." + phraseCounter + ".text", currentLocale.getTranslated());
                    if (!currentLocale.getQaComment().equals("")) {
                        prop.setProperty("" + componentCounter + "." + fileCounter + "." + phraseCounter + ".comment", currentLocale.getQaComment());
                    }
                    if (currentLocale.getQaStatus() == 0) continue;
                    prop.setProperty("" + componentCounter + "." + fileCounter + "." + phraseCounter + ".qa", "" + currentLocale.getQaStatus());
                }
                int maxPhrase = phraseCounter + 1;
                if (maxPhrase <= 0) continue;
                prop.setProperty("" + componentCounter + "." + fileCounter + ".phraseCount", "" + maxPhrase);
            }
            int maxFile = fileCounter + 1;
            if (maxFile <= 0) continue;
            prop.setProperty("" + componentCounter + ".fileCount", "" + maxFile);
        }
        int maxComponent = componentCounter + 1;
        if (maxComponent > 0) {
            prop.setProperty("componentCount", "" + maxComponent);
        }
        try {
            FileOutputStream fos = new FileOutputStream(fn);
            ZipOutputStream zos = new ZipOutputStream(fos);
            ZipEntry ze = new ZipEntry("glossary.txt");
            zos.putNextEntry(ze);
            prop.store(zos, "Glossary file for MozillaTranslator");
            zos.closeEntry();
            zos.close();
        }
        catch (IOException e) {
            Log.write("Error exporting glossary file");
        }
    }
}

