/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.translator.datamodel;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.swing.AbstractListModel;
import org.mozilla.translator.datamodel.Filter;
import org.mozilla.translator.datamodel.Phrase;
import org.mozilla.translator.kernel.Log;

public class FilterList
extends AbstractListModel {
    private static FilterList instance;
    private List ourList = new ArrayList();

    public static FilterList getDefaultInstance() {
        if (instance == null) {
            instance = new FilterList();
        }
        return instance;
    }

    public FilterList() {
        Properties prop = new Properties();
        try {
            FileInputStream fis = new FileInputStream("MozillaTranslator_filter.properties");
            prop.load(fis);
            fis.close();
            int count = Integer.parseInt(prop.getProperty("filterCount"));
            int i = 1;
            while (i <= count) {
                String title = prop.getProperty("filter." + i + ".title");
                int rule = Integer.parseInt(prop.getProperty("filter." + i + ".rule"));
                int field = Integer.parseInt(prop.getProperty("filter." + i + ".field"));
                String value = prop.getProperty("filter." + i + ".text");
                Filter tempFilter = new Filter(title, rule, field, value);
                this.ourList.add(tempFilter);
                ++i;
            }
        }
        catch (IOException iOException) {}
    }

    public boolean check(Phrase p) {
        Iterator i = this.ourList.iterator();
        boolean result = false;
        while (i.hasNext() && !result) {
            Filter f = (Filter)i.next();
            result = f.check(p);
        }
        return result;
    }

    public void save() {
        Properties saveProp = new Properties();
        int count = 0;
        Iterator i = this.ourList.iterator();
        while (i.hasNext()) {
            ++count;
            Filter f = (Filter)i.next();
            String title = f.getTitle();
            int field = f.getField();
            int rule = f.getRule();
            String text = f.getText();
            saveProp.setProperty("filter." + count + ".title", title);
            saveProp.setProperty("filter." + count + ".field", Integer.toString(field));
            saveProp.setProperty("filter." + count + ".rule", Integer.toString(rule));
            saveProp.setProperty("filter." + count + ".text", text);
        }
        saveProp.setProperty("filterCount", Integer.toString(count));
        try {
            FileOutputStream fos = new FileOutputStream("MozillaTranslator_filter.properties");
            saveProp.store(fos, "Mozilla Translator filters. DO NOT EDIT");
            fos.close();
        }
        catch (Exception e) {
            Log.write("Error writing filters to disk");
            Log.write("Exception : " + e);
        }
    }

    public List getList() {
        return this.ourList;
    }

    public int getSize() {
        return this.ourList.size();
    }

    public Object getElementAt(int index) {
        Filter f = (Filter)this.ourList.get(index);
        return f;
    }

    public void removeElement(Filter value) {
        this.ourList.remove(value);
        this.fireContentsChanged(this, 0, this.ourList.size() + 1);
    }

    public void addElement(Filter value) {
        this.ourList.add(value);
        this.fireContentsChanged(this, 0, this.ourList.size());
    }

    public void fyr() {
        this.fireContentsChanged(this, 0, this.ourList.size());
    }
}

