/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.translator.datamodel;

import org.mozilla.translator.datamodel.Phrase;

public class Filter {
    public static final int FIELD_KEY = 1;
    public static final int FIELD_ORIGINAL = 2;
    public static final int RULE_EQUALS = 1;
    public static final int RULE_CONTAINS = 2;
    public static final int RULE_STARTSWITH = 3;
    public static final int RULE_ENDSWITH = 4;
    private String title;
    private int rule;
    private int field;
    private String text;

    public Filter(String title, int rule, int field, String text) {
        this.title = title;
        this.rule = rule;
        this.field = field;
        this.text = text;
    }

    public String toString() {
        return this.title;
    }

    public String getTitle() {
        return this.title;
    }

    public int getRule() {
        return this.rule;
    }

    public int getField() {
        return this.field;
    }

    public String getText() {
        return this.text;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setRule(int rule) {
        this.rule = rule;
    }

    public void setField(int field) {
        this.field = field;
    }

    public void setText(String text) {
        this.text = text;
    }

    public boolean check(Phrase ph) {
        String compareText = null;
        boolean result = false;
        switch (this.field) {
            case 1: {
                compareText = ph.getKey();
                break;
            }
            case 2: {
                compareText = ph.getOriginal();
            }
        }
        switch (this.rule) {
            case 1: {
                if (!compareText.equals(this.text)) break;
                result = true;
                break;
            }
            case 2: {
                if (compareText.indexOf(this.text) == -1) break;
                result = true;
                break;
            }
            case 3: {
                if (!compareText.startsWith(this.text)) break;
                result = true;
                break;
            }
            case 4: {
                if (!compareText.endsWith(this.text)) break;
                result = true;
            }
        }
        return result;
    }
}

