/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.translator.actions;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import org.mozilla.translator.datamodel.Glossary;
import org.mozilla.translator.datamodel.LocalePair;
import org.mozilla.translator.datamodel.MozComponent;
import org.mozilla.translator.datamodel.MozFile;
import org.mozilla.translator.datamodel.Phrase;
import org.mozilla.translator.gui.ComplexTableWindow;
import org.mozilla.translator.gui.MainWindow;
import org.mozilla.translator.gui.ShowWhatDialog;
import org.mozilla.translator.gui.models.ComplexColumn;

public class ViewUntranslatedAction
extends AbstractAction {
    public ViewUntranslatedAction() {
        super("Untranslated", null);
    }

    public void actionPerformed(ActionEvent evt) {
        MainWindow mw = MainWindow.getDefaultInstance();
        ShowWhatDialog swd = new ShowWhatDialog((Frame)mw, true);
        List doCols = swd.visDialog();
        if (doCols != null) {
            ComplexColumn fcol = (ComplexColumn)doCols.get(0);
            String doLocale = fcol.getLocale();
            ArrayList<Phrase> untranslatedList = new ArrayList<Phrase>();
            List componentList = Glossary.getDefaultInstance().getAllComponents();
            Iterator componentIterator = componentList.iterator();
            while (componentIterator.hasNext()) {
                MozComponent currentComponent = (MozComponent)componentIterator.next();
                List fileList = currentComponent.getAllFiles();
                Iterator fileIterator = fileList.iterator();
                while (fileIterator.hasNext()) {
                    MozFile currentFile = (MozFile)fileIterator.next();
                    List phraseList = currentFile.getAllPhrases();
                    Iterator phraseIterator = phraseList.iterator();
                    while (phraseIterator.hasNext()) {
                        Phrase currentPhrase = (Phrase)phraseIterator.next();
                        LocalePair currentLocale = currentPhrase.getLocale(doLocale);
                        if (currentLocale != null || currentPhrase.getKeepOriginal()) continue;
                        untranslatedList.add(currentPhrase);
                    }
                }
            }
            Collections.sort(untranslatedList);
            ComplexTableWindow ctw = new ComplexTableWindow("Unstranslated strings", untranslatedList, doCols);
        }
    }
}

