/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.translator.actions;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import org.mozilla.translator.datamodel.Glossary;
import org.mozilla.translator.datamodel.MozComponent;
import org.mozilla.translator.datamodel.MozFile;
import org.mozilla.translator.datamodel.Phrase;
import org.mozilla.translator.gui.ComplexTableWindow;
import org.mozilla.translator.gui.MainWindow;
import org.mozilla.translator.gui.ShowWhatDialog;
import org.mozilla.translator.gui.models.ComplexColumn;

public class ViewRedundantAction
extends AbstractAction {
    public ViewRedundantAction() {
        super("Redundant entries", null);
    }

    public void actionPerformed(ActionEvent evt) {
        MainWindow mw = MainWindow.getDefaultInstance();
        ShowWhatDialog swd = new ShowWhatDialog((Frame)mw, true);
        List wCols = swd.visDialog();
        if (wCols != null) {
            ComplexColumn cc = (ComplexColumn)wCols.get(0);
            String doLocale = cc.getLocale();
            ArrayList all = new ArrayList();
            ArrayList toWindow = new ArrayList();
            Phrase spacePhrase = new Phrase("", "", "", null);
            List componentList = Glossary.getDefaultInstance().getAllComponents();
            Iterator componentIterator = componentList.iterator();
            while (componentIterator.hasNext()) {
                MozComponent currentComponent = (MozComponent)componentIterator.next();
                List fileList = currentComponent.getAllFiles();
                Iterator fileIterator = fileList.iterator();
                while (fileIterator.hasNext()) {
                    MozFile currentFile = (MozFile)fileIterator.next();
                    all.addAll(currentFile.getAllPhrases());
                }
            }
            while (all.size() > 1) {
                ArrayList<Phrase> redundant = new ArrayList<Phrase>();
                Iterator phraseIterator = all.iterator();
                Phrase testPhrase = (Phrase)phraseIterator.next();
                phraseIterator.remove();
                redundant.add(testPhrase);
                while (phraseIterator.hasNext()) {
                    Phrase currentPhrase = (Phrase)phraseIterator.next();
                    if (!testPhrase.getOriginal().equals(currentPhrase.getOriginal())) continue;
                    redundant.add(currentPhrase);
                    phraseIterator.remove();
                }
                if (redundant.size() <= 1) continue;
                toWindow.addAll(redundant);
                toWindow.add(spacePhrase);
            }
            ComplexTableWindow ctw = new ComplexTableWindow("Redundant original texts", toWindow, wCols);
        }
    }
}

