/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.translator.actions;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import org.mozilla.translator.datamodel.Glossary;
import org.mozilla.translator.datamodel.MozComponent;
import org.mozilla.translator.datamodel.MozFile;
import org.mozilla.translator.datamodel.Phrase;
import org.mozilla.translator.gui.ComplexTableWindow;
import org.mozilla.translator.gui.MainWindow;
import org.mozilla.translator.gui.ShowWhatDialog;

public class ViewKeepAction
extends AbstractAction {
    public ViewKeepAction() {
        super("Keep Original", null);
    }

    public void actionPerformed(ActionEvent evt) {
        MainWindow mw = MainWindow.getDefaultInstance();
        ShowWhatDialog swd = new ShowWhatDialog((Frame)mw, true);
        List wCols = swd.visDialog();
        if (wCols != null) {
            ArrayList<Phrase> toWindow = new ArrayList<Phrase>();
            List componentList = Glossary.getDefaultInstance().getAllComponents();
            Iterator componentIterator = componentList.iterator();
            while (componentIterator.hasNext()) {
                MozComponent currentComponent = (MozComponent)componentIterator.next();
                List fileList = currentComponent.getAllFiles();
                Iterator fileIterator = fileList.iterator();
                while (fileIterator.hasNext()) {
                    MozFile currentFile = (MozFile)fileIterator.next();
                    List phraseList = currentFile.getAllPhrases();
                    Iterator phraseIterator = phraseList.iterator();
                    while (phraseIterator.hasNext()) {
                        Phrase currentPhrase = (Phrase)phraseIterator.next();
                        if (!currentPhrase.getKeepOriginal()) continue;
                        toWindow.add(currentPhrase);
                    }
                }
            }
            Collections.sort(toWindow);
            ComplexTableWindow ctw = new ComplexTableWindow("Strings with keep original", toWindow, wCols);
        }
    }
}

