/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.translator.kernel;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.swing.AbstractListModel;
import org.mozilla.translator.datamodel.Entry;
import org.mozilla.translator.kernel.Filter;
import org.mozilla.translator.kernel.Log;

public class FilterList
extends AbstractListModel {
    private static FilterList instance;
    private List ourList = new ArrayList();
    private int size;

    public static FilterList getDefaultInstance() {
        if (instance == null) {
            instance = new FilterList();
        }
        return instance;
    }

    private FilterList() {
        Properties properties = new Properties();
        try {
            FileInputStream fileInputStream = new FileInputStream("MozillaTranslator_filter.properties");
            properties.load(fileInputStream);
            fileInputStream.close();
            int n = Integer.parseInt(properties.getProperty("filter.count"));
            int n2 = 1;
            while (n2 <= n) {
                String string = properties.getProperty("filter." + n2 + ".title");
                int n3 = Integer.parseInt(properties.getProperty("filter." + n2 + ".rule"));
                int n4 = Integer.parseInt(properties.getProperty("filter." + n2 + ".field"));
                String string2 = properties.getProperty("filter." + n2 + ".text");
                Filter filter = new Filter(string, n3, n4, string2);
                this.ourList.add(filter);
                ++n2;
            }
        }
        catch (IOException iOException) {
            Log.write("No filters found");
        }
    }

    public List getList() {
        return this.ourList;
    }

    public boolean check(Entry entry) {
        Iterator iterator = this.ourList.iterator();
        boolean bl = false;
        while (iterator.hasNext() && !bl) {
            Filter filter = (Filter)iterator.next();
            bl = filter.check(entry);
        }
        return bl;
    }

    public void save() {
        Properties properties = new Properties();
        int n = 0;
        Iterator iterator = this.ourList.iterator();
        while (iterator.hasNext()) {
            ++n;
            Filter filter = (Filter)iterator.next();
            String string = filter.getTitle();
            int n2 = filter.getField();
            int n3 = filter.getRule();
            String string2 = filter.getText();
            properties.setProperty("filter." + n + ".title", string);
            properties.setProperty("filter." + n + ".field", Integer.toString(n2));
            properties.setProperty("filter." + n + ".rule", Integer.toString(n3));
            properties.setProperty("filter." + n + ".text", string2);
        }
        properties.setProperty("filter.count", Integer.toString(n));
        try {
            FileOutputStream fileOutputStream = new FileOutputStream("MozillaTranslator_filter.properties");
            properties.store(fileOutputStream, "Mozilla Translator filters. DO NOT EDIT");
            fileOutputStream.close();
        }
        catch (Exception exception) {
            Log.write("Error writing filters to disk");
            Log.write("Exception : " + exception);
        }
    }

    public int getSize() {
        return this.ourList.size();
    }

    public Object getElementAt(int n) {
        Filter filter = (Filter)this.ourList.get(n);
        return filter;
    }

    public void removeElement(Filter filter) {
        this.ourList.remove(filter);
        this.fireContentsChanged(this, 0, this.ourList.size() + 1);
    }

    public void addElement(Filter filter) {
        this.ourList.add(filter);
        this.fireContentsChanged(this, 0, this.ourList.size());
    }

    public void fyr() {
        this.fireContentsChanged(this, 0, this.ourList.size());
    }
}

