/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.translator.io;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.mozilla.translator.datamodel.Entry;
import org.mozilla.translator.io.MozWriter;
import org.mozilla.translator.kernel.Log;

public class DTDWriter
implements MozWriter {
    private FileOutputStream fos;
    private OutputStreamWriter osw;
    private BufferedWriter bw;

    public DTDWriter(String string) {
        try {
            this.fos = new FileOutputStream(string);
            this.osw = new OutputStreamWriter((OutputStream)this.fos, "UTF-8");
            this.bw = new BufferedWriter(this.osw);
        }
        catch (Exception exception) {
            Log.write("Error opening DTD file");
            Log.write("Exception: " + exception);
        }
    }

    public void writePrefix() {
        String string = "<!-- Translated with MozillaTranslator v2-->";
        try {
            this.bw.write(string, 0, string.length());
            this.bw.newLine();
        }
        catch (Exception exception) {
            Log.write("Error writeing prefix in dtd file");
            Log.write("Exception " + exception);
        }
    }

    public void writeEntry(Entry entry) {
        String string = entry.getKey();
        String string2 = entry.getTranslated();
        String string3 = string2.indexOf("\"") == -1 ? "<!ENTITY " + string + " \"" + string2 + "\">" : "<!ENTITY " + string + " '" + string2 + "'>";
        try {
            this.bw.write(string3, 0, string3.length());
            this.bw.newLine();
        }
        catch (Exception exception) {
            Log.write("Error writeing line in dtd file");
            Log.write("Exception: " + exception);
        }
    }

    public void close() {
        try {
            this.bw.close();
        }
        catch (Exception exception) {
            Log.write("Error closeing translated file");
            Log.write("Exception: " + exception);
        }
    }
}

