/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.translator.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.JTree;
import org.mozilla.translator.actions.FilterAction;
import org.mozilla.translator.actions.LoadAction;
import org.mozilla.translator.actions.PackAction;
import org.mozilla.translator.actions.QuitAction;
import org.mozilla.translator.actions.SaveAction;
import org.mozilla.translator.actions.ScanAction;
import org.mozilla.translator.actions.TurnOnAction;
import org.mozilla.translator.datamodel.ChromeTree;
import org.mozilla.translator.datamodel.TranslationTable;

public class MainWindow
extends JFrame {
    private static MainWindow instance;
    private JTree tree = ChromeTree.getDefaultInstance().getTree();
    private TranslationTable tableModel;
    private JTable table;
    private JScrollPane treeScroll = new JScrollPane(this.tree);
    private JScrollPane tableScroll;
    private JSplitPane split;
    private JToolBar toolbar;
    private JLabel statusLabel;
    private JMenuBar menubar;
    private JMenu menu;

    private MainWindow() {
        super("MozillaTranslator");
        this.tableModel = TranslationTable.getDefaultInstance();
        this.table = new JTable(this.tableModel);
        this.tableScroll = new JScrollPane(this.table);
        this.split = new JSplitPane(1, this.treeScroll, this.tableScroll);
        this.split.setOneTouchExpandable(true);
        this.createMenuAndBar();
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.split, "Center");
        this.statusLabel = new JLabel("Status: xxxxxxxxxxxxxxxxxxxxxxxxxxx");
        this.statusLabel.setText("Status: Program started");
        this.getContentPane().add((Component)this.statusLabel, "South");
        this.pack();
        this.placeAtCenter();
    }

    private void addToMenuAndBar(AbstractAction act) {
        JButton junk = this.toolbar.add(act);
        JMenuItem junk2 = this.menu.add(act);
    }

    private void createMenuAndBar() {
        this.menubar = new JMenuBar();
        this.menu = new JMenu("Menu");
        this.toolbar = new JToolBar();
        this.addToMenuAndBar(new LoadAction());
        this.addToMenuAndBar(new SaveAction());
        this.addToMenuAndBar(new ScanAction());
        this.addToMenuAndBar(new PackAction());
        this.addToMenuAndBar(new TurnOnAction());
        this.addToMenuAndBar(new FilterAction());
        this.addToMenuAndBar(new QuitAction());
        this.menubar.add(this.menu);
        this.setJMenuBar(this.menubar);
    }

    public static MainWindow getDefaultInstance() {
        if (instance == null) {
            instance = new MainWindow();
        }
        return instance;
    }

    public String getStatus() {
        return this.statusLabel.getText();
    }

    public TranslationTable getTranslationTable() {
        return this.tableModel;
    }

    private void placeAtCenter() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension scr = tk.getScreenSize();
        Dimension dia = this.getSize();
        int x = (int)(scr.getWidth() / 2.0 - dia.getWidth() / 2.0);
        int y = (int)(scr.getHeight() / 2.0 - dia.getHeight() / 2.0);
        ((Component)this).setLocation(x, y);
    }

    public void setStatus(String status) {
        this.statusLabel.setText(status);
    }
}

