/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.translator.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.mozilla.translator.gui.EditFilterDialog;
import org.mozilla.translator.gui.MainWindow;
import org.mozilla.translator.kernel.Filter;
import org.mozilla.translator.kernel.FilterList;

public class FilterListDialog
extends JDialog {
    private JPanel listPanel;
    private JScrollPane jScrollPane1;
    private JList flist;
    private JPanel adminPanel;
    private JButton addButton;
    private JButton editButton;
    private JButton removeButton;
    private JPanel exitPanel;
    private JButton okayButton;
    private boolean saveList = false;

    public FilterListDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.pack();
        this.placeAtCenter();
    }

    private void initComponents() {
        this.listPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.flist = new JList();
        this.adminPanel = new JPanel();
        this.addButton = new JButton();
        this.editButton = new JButton();
        this.removeButton = new JButton();
        this.exitPanel = new JPanel();
        this.okayButton = new JButton();
        this.setTitle("Filters");
        this.setDefaultCloseOperation(0);
        this.flist.setModel(FilterList.getDefaultInstance());
        this.jScrollPane1.setViewportView(this.flist);
        this.listPanel.add(this.jScrollPane1);
        this.getContentPane().add((Component)this.listPanel, "Center");
        this.adminPanel.setLayout(new GridLayout(3, 1));
        this.addButton.setText("Add");
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FilterListDialog.this.addButtonPressed(actionEvent);
            }
        });
        this.adminPanel.add(this.addButton);
        this.editButton.setText("Edit");
        this.editButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FilterListDialog.this.editButtonPressed(actionEvent);
            }
        });
        this.adminPanel.add(this.editButton);
        this.removeButton.setText("Remove");
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FilterListDialog.this.removeButtonPressed(actionEvent);
            }
        });
        this.adminPanel.add(this.removeButton);
        this.getContentPane().add((Component)this.adminPanel, "East");
        this.okayButton.setText("Okay");
        this.okayButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FilterListDialog.this.okayButtonActionPerformed(actionEvent);
            }
        });
        this.exitPanel.add(this.okayButton);
        this.getContentPane().add((Component)this.exitPanel, "South");
    }

    private void okayButtonActionPerformed(ActionEvent actionEvent) {
        ((Component)this).setVisible(false);
    }

    private void removeButtonPressed(ActionEvent actionEvent) {
        FilterList filterList = FilterList.getDefaultInstance();
        Filter filter = (Filter)this.flist.getSelectedValue();
        filterList.removeElement(filter);
        this.pack();
    }

    private void editButtonPressed(ActionEvent actionEvent) {
        FilterList filterList = FilterList.getDefaultInstance();
        Filter filter = (Filter)this.flist.getSelectedValue();
        if (filter != null) {
            EditFilterDialog editFilterDialog = new EditFilterDialog((Frame)MainWindow.getDefaultInstance(), true);
            boolean bl = editFilterDialog.visDialog(filter);
            filterList.fyr();
            this.pack();
        }
    }

    private void addButtonPressed(ActionEvent actionEvent) {
        FilterList filterList = FilterList.getDefaultInstance();
        Filter filter = new Filter("unnamed", 1, 1, "notext");
        EditFilterDialog editFilterDialog = new EditFilterDialog((Frame)MainWindow.getDefaultInstance(), true);
        boolean bl = editFilterDialog.visDialog(filter);
        if (bl) {
            filterList.addElement(filter);
        }
        this.pack();
    }

    public void visDialog() {
        ((Component)this).setVisible(true);
        FilterList filterList = FilterList.getDefaultInstance();
        filterList.save();
    }

    private void placeAtCenter() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        Dimension dimension2 = this.getSize();
        int n = (int)(dimension.getWidth() / 2.0 - dimension2.getWidth() / 2.0);
        int n2 = (int)(dimension.getHeight() / 2.0 - dimension2.getHeight() / 2.0);
        ((Component)this).setLocation(n, n2);
    }
}

