/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.translator.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.mozilla.translator.kernel.Filter;

public class EditFilterDialog
extends JDialog {
    private JPanel jPanel1;
    private JLabel titleLabel;
    private JTextField titleField;
    private JLabel fieldLabel;
    private JComboBox fieldComboBox;
    private JLabel ruleLabel;
    private JComboBox ruleComboBox;
    private JLabel textLabel;
    private JTextField textField;
    private JPanel jPanel2;
    private JButton okayButton;
    private JButton cancelButton;
    private boolean okayed;

    public EditFilterDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.pack();
        this.placeAtCenter();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.titleLabel = new JLabel();
        this.titleField = new JTextField();
        this.fieldLabel = new JLabel();
        String[] stringArray = new String[]{"Key", "orginal"};
        this.fieldComboBox = new JComboBox<String>(stringArray);
        this.ruleLabel = new JLabel();
        String[] stringArray2 = new String[]{"Equals", "Contains", "Starts with", "Ends with"};
        this.ruleComboBox = new JComboBox<String>(stringArray2);
        this.textLabel = new JLabel();
        this.textField = new JTextField();
        this.jPanel2 = new JPanel();
        this.okayButton = new JButton();
        this.cancelButton = new JButton();
        this.setTitle("Edit Filter");
        this.setDefaultCloseOperation(0);
        this.jPanel1.setLayout(new GridLayout(4, 2));
        this.titleLabel.setText("Title");
        this.jPanel1.add(this.titleLabel);
        this.titleField.setColumns(20);
        this.titleField.setText("Title goes here");
        this.jPanel1.add(this.titleField);
        this.fieldLabel.setText("Field");
        this.jPanel1.add(this.fieldLabel);
        this.jPanel1.add(this.fieldComboBox);
        this.ruleLabel.setText("Rule");
        this.jPanel1.add(this.ruleLabel);
        this.jPanel1.add(this.ruleComboBox);
        this.textLabel.setText("Text");
        this.jPanel1.add(this.textLabel);
        this.textField.setText("jTextField2");
        this.jPanel1.add(this.textField);
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.okayButton.setText("Okay");
        this.okayButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditFilterDialog.this.okayButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel2.add(this.okayButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditFilterDialog.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel2.add(this.cancelButton);
        this.getContentPane().add((Component)this.jPanel2, "South");
    }

    private void okayButtonActionPerformed(ActionEvent actionEvent) {
        this.okayed = true;
        ((Component)this).setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.okayed = false;
        ((Component)this).setVisible(false);
    }

    public boolean visDialog(Filter filter) {
        this.okayed = false;
        this.titleField.setText(filter.getTitle());
        this.textField.setText(filter.getText());
        int n = filter.getField();
        switch (n) {
            case 1: {
                this.fieldComboBox.setSelectedIndex(0);
                break;
            }
            case 2: {
                this.fieldComboBox.setSelectedIndex(1);
            }
        }
        n = filter.getRule();
        switch (n) {
            case 1: {
                this.ruleComboBox.setSelectedIndex(0);
                break;
            }
            case 2: {
                this.ruleComboBox.setSelectedIndex(1);
                break;
            }
            case 3: {
                this.ruleComboBox.setSelectedIndex(2);
                break;
            }
            case 4: {
                this.ruleComboBox.setSelectedIndex(3);
            }
        }
        ((Component)this).setVisible(true);
        if (this.okayed) {
            filter.setTitle(this.titleField.getText());
            filter.setText(this.textField.getText());
            switch (this.fieldComboBox.getSelectedIndex()) {
                case 0: {
                    filter.setField(1);
                    break;
                }
                case 1: {
                    filter.setField(2);
                }
            }
            switch (this.ruleComboBox.getSelectedIndex()) {
                case 0: {
                    filter.setRule(1);
                    break;
                }
                case 1: {
                    filter.setRule(2);
                    break;
                }
                case 2: {
                    filter.setRule(3);
                    break;
                }
                case 3: {
                    filter.setRule(4);
                }
            }
        }
        this.dispose();
        return this.okayed;
    }

    public static void main(String[] stringArray) {
        new EditFilterDialog((Frame)new JFrame(), true).show();
    }

    private void placeAtCenter() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        Dimension dimension2 = this.getSize();
        int n = (int)(dimension.getWidth() / 2.0 - dimension2.getWidth() / 2.0);
        int n2 = (int)(dimension.getHeight() / 2.0 - dimension2.getHeight() / 2.0);
        ((Component)this).setLocation(n, n2);
    }
}

