/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.translator.datamodel;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.mozilla.translator.datamodel.Entry;
import org.mozilla.translator.datamodel.MozFile;
import org.mozilla.translator.gui.MainWindow;

public class TranslationTable
extends AbstractTableModel {
    private static TranslationTable instance;
    private List rowList = new ArrayList();
    private int rowCount = 1;
    private boolean loaded = false;
    private MozFile loadedFile;

    private TranslationTable() {
        Entry e = new Entry("No file Loaded", "No File Loaded", "No file loaded");
        this.rowList.add(e);
    }

    public Class getColumnClass(int columnIndex) {
        Class<?> result = null;
        switch (columnIndex) {
            case 0: 
            case 1: 
            case 2: {
                String temp = "class is a string";
                result = temp.getClass();
                break;
            }
            case 3: {
                Boolean temp = new Boolean(true);
                result = temp.getClass();
                break;
            }
        }
        return result;
    }

    public int getColumnCount() {
        return 4;
    }

    public String getColumnName(int columnIndex) {
        String name = "";
        switch (columnIndex) {
            case 0: {
                name = "Key";
                break;
            }
            case 1: {
                name = "Original Text";
                break;
            }
            case 2: {
                name = "Translated Text";
                break;
            }
            case 3: {
                name = "Keep Original";
                break;
            }
        }
        return name;
    }

    public static TranslationTable getDefaultInstance() {
        if (instance == null) {
            instance = new TranslationTable();
        }
        return instance;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        Entry row = (Entry)this.rowList.get(rowIndex);
        Object result = null;
        switch (columnIndex) {
            case 0: {
                result = row.getKey();
                break;
            }
            case 1: {
                result = row.getOriginal();
                break;
            }
            case 2: {
                result = row.getTranslated();
                break;
            }
            case 3: {
                result = new Boolean(row.getKeepOriginal());
                break;
            }
        }
        return result;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        boolean result = false;
        switch (columnIndex) {
            case 0: 
            case 1: {
                result = false;
                break;
            }
            case 2: {
                Entry row = (Entry)this.rowList.get(rowIndex);
                if (row.getKeepOriginal()) {
                    result = false;
                    break;
                }
                result = true;
                break;
            }
            case 3: {
                result = true;
                break;
            }
        }
        return result;
    }

    public void load(MozFile file) {
        List tempList = file.load();
        if (tempList.size() > 0) {
            this.rowList = tempList;
            this.rowCount = this.rowList.size();
            this.loadedFile = file;
            this.loaded = true;
            MainWindow.getDefaultInstance().setTitle("MozillaTranslator - " + file);
            MainWindow.getDefaultInstance().setStatus("Status: File loaded");
            this.fireTableDataChanged();
        }
    }

    public void save() {
        if (this.loaded) {
            this.loadedFile.save(this.rowList);
            MainWindow.getDefaultInstance().setStatus("Status: File saved");
        }
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        MainWindow mw = MainWindow.getDefaultInstance();
        Entry row = (Entry)this.rowList.get(rowIndex);
        if (columnIndex == 2) {
            String res = (String)aValue;
            row.setTranslated(res);
            mw.setStatus("Status: File changed");
        }
        if (columnIndex == 3) {
            Boolean b = (Boolean)aValue;
            boolean b2 = b;
            row.setKeepOriginal(b2);
            if (b2) {
                row.setTranslated(row.getOriginal());
                this.fireTableCellUpdated(rowIndex, 2);
            }
            mw.setStatus("Status: File changed");
        }
    }
}

