/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.translator.datamodel;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.mozilla.translator.datamodel.Entry;
import org.mozilla.translator.io.DTDReader;
import org.mozilla.translator.io.DTDWriter;
import org.mozilla.translator.io.MozReader;
import org.mozilla.translator.io.MozWriter;
import org.mozilla.translator.io.PropertiesReader;
import org.mozilla.translator.io.PropertiesWriter;
import org.mozilla.translator.kernel.FilterList;
import org.mozilla.translator.kernel.Settings;

public class MozFile {
    public static final int TYPE_DTD = 1;
    public static final int TYPE_PROPERTIES = 2;
    private int type;
    private String source;
    private String dest;
    private String display;
    private String component;

    public MozFile(String string, String string2) {
        this.component = string;
        this.display = string2;
        String string3 = Settings.getString("chrome.basedir");
        String string4 = Settings.getString("chrome.source");
        String string5 = Settings.getString("chrome.dest");
        String string6 = string3 + File.separator + this.component + File.separator + "locale" + File.separator;
        this.source = string6 + string4 + File.separator + string2;
        this.dest = string6 + string5 + File.separator + string2;
        this.display = string2;
        this.component = string;
        if (string2.endsWith(".dtd")) {
            this.type = 1;
        }
        if (string2.endsWith(".properties")) {
            this.type = 2;
        }
    }

    public String toString() {
        return this.display;
    }

    public String getName() {
        return this.display;
    }

    public String getComponent() {
        return this.component;
    }

    public String getSource() {
        return this.source;
    }

    public String getDestination() {
        return this.dest;
    }

    public int getType() {
        return this.type;
    }

    public List load() {
        Entry entry;
        MozReader mozReader = null;
        MozReader mozReader2 = null;
        ArrayList<Entry> arrayList = new ArrayList<Entry>();
        boolean bl = false;
        if (this.type == 1) {
            mozReader = new DTDReader(this.source);
            mozReader2 = new DTDReader(this.dest);
        }
        if (this.type == 2) {
            mozReader = new PropertiesReader(this.source);
            mozReader2 = new PropertiesReader(this.dest);
        }
        bl = false;
        boolean bl2 = mozReader.getOpened();
        while (!bl && bl2) {
            entry = mozReader.getNext();
            if (entry != null) {
                if (arrayList.contains(entry)) continue;
                arrayList.add(entry);
                entry.setKeepOriginal(FilterList.getDefaultInstance().check(entry));
                continue;
            }
            bl = true;
            mozReader.close();
        }
        bl2 = mozReader2.getOpened();
        bl = false;
        while (!bl && bl2) {
            entry = mozReader2.getNext();
            if (entry != null) {
                int n = arrayList.indexOf(entry);
                if (n == -1) continue;
                Entry entry2 = (Entry)arrayList.get(n);
                entry2.setTranslated(entry.getOriginal());
                if (entry2.getOriginal().equals(entry2.getTranslated())) continue;
                entry2.setKeepOriginal(false);
                continue;
            }
            bl = true;
            mozReader2.close();
        }
        return arrayList;
    }

    public void save(List list) {
        MozWriter mozWriter = null;
        if (this.type == 1) {
            mozWriter = new DTDWriter(this.dest);
        }
        if (this.type == 2) {
            mozWriter = new PropertiesWriter(this.dest);
        }
        mozWriter.writePrefix();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            mozWriter.writeEntry(entry);
        }
        mozWriter.close();
    }
}

