/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.translator.datamodel;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import org.mozilla.translator.kernel.Log;
import org.mozilla.translator.kernel.Settings;

public class MozComponent {
    private boolean turnedOn;
    private String name;
    private String fileName;

    public MozComponent(String string) {
        this.name = string;
        String string2 = Settings.getString("chrome.basedir");
        String string3 = Settings.getString("chrome.dest");
        this.fileName = string2 + File.separator + this.name + File.separator + "locale" + File.separator + "chrome.rdf";
        File file = new File(this.fileName);
        this.turnedOn = file.exists();
    }

    public void setName(String string) {
        this.name = string;
    }

    public void turnOn() {
        String[] stringArray = new String[6];
        try {
            FileWriter fileWriter = new FileWriter(this.fileName, false);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            String string = Settings.getString("chrome.dest");
            stringArray[0] = "<RDF:RDF xmlns:RDF=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" ";
            stringArray[1] = "xmlns=\"http://chrome.mozilla.org/rdf#\">\n";
            stringArray[2] = "\t<RDF:Description about=\"chrome://" + this.name + "/locale/\">\n";
            stringArray[3] = "\t\t<name>" + string + "</name>\n";
            stringArray[4] = "\t</RDF:Description>\n";
            stringArray[5] = "</RDF:RDF>\n";
            int n = 0;
            while (n < 6) {
                bufferedWriter.write(stringArray[n]);
                ++n;
            }
            bufferedWriter.close();
        }
        catch (Exception exception) {
            Log.write("Error writing chrome.rdf for " + this.name);
            Log.write("Exception: " + exception);
        }
        this.turnedOn = true;
    }

    public void turnOff() {
        this.turnedOn = false;
        File file = new File(this.fileName);
        if (file.exists()) {
            file.delete();
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean getTurnedOn() {
        return this.turnedOn;
    }

    public String toString() {
        String string = this.name;
        string = this.turnedOn ? string + " - on" : string + " - off";
        return string;
    }
}

