/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.translator.datamodel;

import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.mozilla.translator.datamodel.MozComponent;
import org.mozilla.translator.datamodel.MozFile;
import org.mozilla.translator.kernel.Settings;

public class ChromeTree {
    private static ChromeTree instance;
    private JTree tree;
    private DefaultMutableTreeNode root;

    public static ChromeTree getDefaultInstance() {
        if (instance == null) {
            instance = new ChromeTree();
        }
        return instance;
    }

    private ChromeTree() {
        String string = Settings.getString("chrome.basedir");
        File file = new File(string);
        String string2 = Settings.getString("chrome.source");
        String string3 = Settings.getString("chrome.dest");
        this.root = new DefaultMutableTreeNode("root");
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            int n = 0;
            while (n < stringArray.length) {
                String string4 = string + File.separator + stringArray[n];
                File file2 = new File(string4);
                if (file2.isDirectory()) {
                    MozComponent mozComponent = new MozComponent(stringArray[n]);
                    DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(mozComponent);
                    String string5 = string4 + File.separator + "locale" + File.separator + string2;
                    File file3 = new File(string5);
                    String[] stringArray2 = file3.list();
                    if (stringArray2 != null) {
                        String string6 = string4 + File.separator + "locale" + File.separator + string3;
                        File file4 = new File(string6);
                        if (!file4.exists()) {
                            file4.mkdir();
                        }
                        int n2 = 0;
                        while (n2 < stringArray2.length) {
                            MozFile mozFile = new MozFile(stringArray[n], stringArray2[n2]);
                            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(mozFile);
                            defaultMutableTreeNode.add(defaultMutableTreeNode2);
                            ++n2;
                        }
                        this.root.add(defaultMutableTreeNode);
                    }
                }
                ++n;
            }
        }
        this.tree = new JTree(this.root);
        this.tree.setRootVisible(true);
    }

    public JTree getTree() {
        return this.tree;
    }

    public List getRelevantFiles(TreePath treePath) {
        ArrayList<MozFile> arrayList = new ArrayList<MozFile>();
        int n = treePath.getPathCount();
        switch (n) {
            case 1: {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
                while (enumeration.hasMoreElements()) {
                    DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
                    Enumeration<TreeNode> enumeration2 = defaultMutableTreeNode2.children();
                    while (enumeration2.hasMoreElements()) {
                        DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)enumeration2.nextElement();
                        MozFile mozFile = (MozFile)defaultMutableTreeNode3.getUserObject();
                        arrayList.add(mozFile);
                    }
                }
                break;
            }
            case 2: {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
                while (enumeration.hasMoreElements()) {
                    DefaultMutableTreeNode defaultMutableTreeNode4 = (DefaultMutableTreeNode)enumeration.nextElement();
                    MozFile mozFile = (MozFile)defaultMutableTreeNode4.getUserObject();
                    arrayList.add(mozFile);
                }
                break;
            }
            case 3: {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                MozFile mozFile = (MozFile)defaultMutableTreeNode.getUserObject();
                arrayList.add(mozFile);
            }
        }
        return arrayList;
    }

    public TreePath getSelected() {
        TreePath treePath = this.tree.getLeadSelectionPath();
        return treePath;
    }

    public DefaultMutableTreeNode getRoot() {
        return this.root;
    }
}

