/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.pluglet;

import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.util.Enumeration;
import java.util.Vector;

class PlugletPolicy
extends Policy {
    private Policy peer;
    private Vector permissions;

    PlugletPolicy(Policy peer) {
        this.peer = peer;
        this.permissions = null;
    }

    void grantPermission(CodeSource codesource, PermissionCollection per) {
        if (this.permissions == null) {
            this.permissions = new Vector(10);
        }
        Object[] pair = new Object[]{codesource, per};
        this.permissions.add(pair);
    }

    public PermissionCollection getPermissions(CodeSource codesource) {
        PermissionCollection collection = this.peer.getPermissions(codesource);
        if (collection == null) {
            collection = new Permissions();
        }
        int i = 0;
        while (i < this.permissions.size()) {
            Object[] pair = (Object[])this.permissions.elementAt(i);
            CodeSource code = (CodeSource)pair[0];
            if (code.implies(codesource)) {
                Enumeration<Permission> e = ((PermissionCollection)pair[1]).elements();
                while (e.hasMoreElements()) {
                    collection.add(e.nextElement());
                }
            }
            ++i;
        }
        return collection;
    }

    public void refresh() {
        this.peer.refresh();
    }
}

