/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.pluglet;

import java.awt.Button;
import java.awt.Dimension;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.mozilla.pluglet.PlugletFactory;
import org.mozilla.pluglet.PlugletPolicy;
import org.mozilla.util.DebugPluglet;

public class PlugletLoader {
    private static PlugletPolicy policy;

    public static PlugletFactory getPluglet(String path) {
        try {
            DebugPluglet.print("-- PlugletLoader.getPluglet(" + path + ")\n");
            URL url = new URL("file://" + path);
            URLClassLoader loader = URLClassLoader.newInstance(new URL[]{url});
            URL manifestURL = new URL("jar:file://" + path + "!/META-INF/MANIFEST.MF");
            InputStream inputStream = manifestURL.openStream();
            Manifest manifest = new Manifest(inputStream);
            Attributes attr = manifest.getMainAttributes();
            String plugletClassName = attr.getValue("Pluglet-Class");
            DebugPluglet.print("-- PlugletLoader.getPluglet class name " + plugletClassName + "\n");
            DebugPluglet.print("-- PL url[0] " + loader.getURLs()[0] + "\n");
            if (plugletClassName == null) {
                return null;
            }
            if (policy == null) {
                policy = new PlugletPolicy(Policy.getPolicy());
            }
            if (policy != Policy.getPolicy()) {
                Policy.setPolicy(policy);
            }
            CodeSource codesource = new CodeSource(url, null);
            AllPermission perm = new AllPermission();
            PermissionCollection collection = ((Permission)perm).newPermissionCollection();
            collection.add(perm);
            policy.grantPermission(codesource, collection);
            Object pluglet = loader.loadClass(plugletClassName).newInstance();
            if (pluglet instanceof PlugletFactory) {
                DebugPluglet.print("-- ok we have a PlugletFactory\n");
                return (PlugletFactory)pluglet;
            }
            DebugPluglet.print("-- oups we do not have a PlugletFactory\n");
            return null;
        }
        catch (Exception e) {
            DebugPluglet.print("-- PlugletLoader.getPluglet exc " + e);
            e.printStackTrace();
            return null;
        }
    }

    public static String getMIMEDescription(String path) {
        try {
            DebugPluglet.print("-- PlugletLoader.getMIMEDescription(" + path + ")\n");
            URL manifestURL = new URL("jar:file://" + path + "!/META-INF/MANIFEST.MF");
            InputStream inputStream = manifestURL.openStream();
            Manifest manifest = new Manifest(inputStream);
            Attributes attr = manifest.getMainAttributes();
            String mimeDescription = attr.getValue("MIMEDescription");
            DebugPluglet.print("-- PlugletLoader.getMIMEDescription desc " + mimeDescription + "\n");
            return mimeDescription;
        }
        catch (Exception e) {
            DebugPluglet.print(e + "\n");
            e.printStackTrace();
            return null;
        }
    }

    static {
        System.loadLibrary("plugletjni");
        Dimension dimension = new Button().getToolkit().getScreenSize();
        policy = null;
    }
}

